/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.Attributes;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.GeoLocation;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.GeoLocationHandler;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import com.twitterapime.search.TweetEntity;
import com.twitterapime.search.handler.TweetEntityHandler;
import java.util.Hashtable;
import java.util.Vector;

public final class TimelineHandler
extends DefaultXMLHandler {
    private UserAccountHandler userHandler = new UserAccountHandler();
    private TweetHandler tweetHandler = new TweetHandler();
    private GeoLocationHandler locationHandler = new GeoLocationHandler();
    private TweetEntityHandler entityHandler = new TweetEntityHandler();
    private Vector tweetList = new Vector(10);
    private Hashtable userValues;
    private Hashtable retweetUserValues;
    private Hashtable tweetValues;
    private Hashtable retweetValues;
    private Hashtable locationValues;
    private Hashtable retweetLocationValues;
    private Hashtable entityValues;
    private Hashtable retweetEntityValues;
    private SearchDeviceListener listener;

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws ParserException {
        super.startElement(namespaceURI, localName, qName, attrs);
        if (localName.toLowerCase().equals("status")) {
            this.tweetValues = new Hashtable(5);
            this.retweetValues = new Hashtable(5);
            this.userValues = new Hashtable(25);
            this.retweetUserValues = new Hashtable(25);
            this.locationValues = new Hashtable(10);
            this.retweetLocationValues = new Hashtable(10);
            this.entityValues = new Hashtable(3);
            this.retweetEntityValues = new Hashtable(3);
            this.tweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.userValues));
            this.tweetList.addElement(new Tweet(this.tweetValues));
        }
    }

    public void text(String text) throws ParserException {
        text = text.trim();
        if (this.xmlPath.startsWith("/statuses/status/retweeted_status/user/")) {
            this.userHandler.populate(this.retweetUserValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/retweeted_status/geo/")) {
            this.locationHandler.populate(this.retweetLocationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/retweeted_status/place/")) {
            this.locationHandler.populate(this.retweetLocationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/retweeted_status/entities/")) {
            this.entityHandler.populate(this.retweetEntityValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/retweeted_status/")) {
            this.tweetHandler.populate(this.retweetValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/user/")) {
            this.userHandler.populate(this.userValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/geo/")) {
            this.locationHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/place/")) {
            this.locationHandler.populate(this.locationValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/entities/")) {
            this.entityHandler.populate(this.entityValues, this.xmlPath, text);
        } else if (this.xmlPath.startsWith("/statuses/status/")) {
            this.tweetHandler.populate(this.tweetValues, this.xmlPath, text);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws ParserException {
        super.endElement(namespaceURI, localName, qName);
        if (localName.toLowerCase().equals("status")) {
            if (this.retweetValues.size() > 0) {
                if (this.retweetUserValues.size() > 0) {
                    this.retweetValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.retweetUserValues));
                }
                if (this.retweetLocationValues.size() > 0) {
                    this.retweetValues.put("TWEET_LOCATION", new GeoLocation(this.retweetLocationValues));
                }
                if (this.retweetEntityValues.size() > 0) {
                    this.retweetValues.put("TWEET_ENTITY", new TweetEntity(this.retweetEntityValues));
                }
                this.tweetValues.put("TWEET_REPOSTED_TWEET", new Tweet(this.retweetValues));
            }
            if (this.locationValues.size() > 0) {
                this.tweetValues.put("TWEET_LOCATION", new GeoLocation(this.locationValues));
            }
            if (this.entityValues.size() > 0) {
                this.tweetValues.put("TWEET_ENTITY", new TweetEntity(this.entityValues));
            }
            this.fireTweetParsed((Tweet)this.tweetList.lastElement());
        }
    }

    public Tweet[] getParsedTweets() {
        Object[] ts = new Tweet[this.tweetList.size()];
        this.tweetList.copyInto(ts);
        return ts;
    }

    public void setSearchDeviceListener(SearchDeviceListener listener) {
        this.listener = listener;
    }

    private void fireTweetParsed(Tweet tweet) {
        if (this.listener != null) {
            this.listener.tweetFound(tweet);
        }
    }
}

