/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.util.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class GeoLocationHandler {
    public void populate(Hashtable data, String path, String text) {
        if (path.endsWith("/georss:point")) {
            String[] values = StringUtil.split(text, ' ');
            data.put("GEOLOCATION_LATITUDE", values[0]);
            data.put("GEOLOCATION_LONGITUDE", values[1]);
        } else if (path.endsWith("/id")) {
            data.put("GEOLOCATION_PLACE_ID", text);
        } else if (path.endsWith("/name")) {
            data.put("GEOLOCATION_PLACE_NAME", text);
        } else if (path.endsWith("/full_name")) {
            data.put("GEOLOCATION_PLACE_FULL_NAME", text);
        } else if (path.endsWith("/place_type")) {
            data.put("GEOLOCATION_PLACE_TYPE", text);
        } else if (path.endsWith("/url")) {
            data.put("GEOLOCATION_PLACE_URL", text);
        } else if (path.endsWith("/georss:polygon")) {
            data.put("GEOLOCATION_POLYGON", StringUtil.split(text, ' '));
        } else if (path.endsWith("/country")) {
            data.put("GEOLOCATION_COUNTRY", text);
        }
    }

    public void populate(Hashtable data, JSONObject jsonObj) {
        JSONArray coord;
        this.putIf(data, "GEOLOCATION_PLACE_ID", jsonObj, "id");
        this.putIf(data, "GEOLOCATION_PLACE_NAME", jsonObj, "name");
        this.putIf(data, "GEOLOCATION_PLACE_FULL_NAME", jsonObj, "full_name");
        this.putIf(data, "GEOLOCATION_PLACE_TYPE", jsonObj, "place_type");
        this.putIf(data, "GEOLOCATION_PLACE_URL", jsonObj, "url");
        this.putIf(data, "GEOLOCATION_COUNTRY", jsonObj, "country");
        if (jsonObj.has("coordinates") && (coord = jsonObj.getJSONArray("coordinates")).length() >= 2) {
            data.put("GEOLOCATION_LATITUDE", coord.getString(0));
            data.put("GEOLOCATION_LONGITUDE", coord.getString(1));
        }
        if (jsonObj.has("polylines")) {
            JSONArray lines = jsonObj.getJSONArray("polylines");
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < lines.length(); ++i) {
                vector.addElement(lines.getString(i));
            }
            Object[] array = new String[vector.size()];
            vector.copyInto(array);
            data.put("GEOLOCATION_POLYGON", array);
        }
    }

    private void putIf(Hashtable data, String dataKey, JSONObject jsonObj, String jsonKey) {
        if (jsonObj.has(jsonKey)) {
            data.put(dataKey, jsonObj.getString(jsonKey));
        }
    }
}

