/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.Attributes;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.Tweet;
import java.util.Hashtable;
import java.util.Vector;

public final class AccountHandler
extends DefaultXMLHandler {
    private TweetHandler tHandler = new TweetHandler();
    private UserAccountHandler uaHandler = new UserAccountHandler();
    private Hashtable userAccountValues;
    private Hashtable lastTweetValues;
    private Vector usersList = new Vector(10);
    private Vector usersHashList = new Vector(10);
    private long nextCursorIndex;
    private long prevCursorIndex;

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws ParserException {
        super.startElement(namespaceURI, localName, qName, attrs);
        if (localName.toLowerCase().equals("user")) {
            this.userAccountValues = new Hashtable(25);
            this.lastTweetValues = new Hashtable(5);
            this.usersHashList.addElement(this.userAccountValues);
            this.usersList.addElement(new UserAccount(this.userAccountValues));
        }
    }

    public void text(String text) throws ParserException {
        text = text.trim();
        if (this.xmlPath.indexOf("/user/status/") != -1) {
            this.tHandler.populate(this.lastTweetValues, this.xmlPath, text);
        } else if (this.xmlPath.endsWith("/next_cursor")) {
            this.nextCursorIndex = Long.parseLong(text);
        } else if (this.xmlPath.endsWith("/previous_cursor")) {
            this.prevCursorIndex = Long.parseLong(text);
        } else {
            this.uaHandler.populate(this.userAccountValues, this.xmlPath, text);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws ParserException {
        super.endElement(namespaceURI, localName, qName);
        if (localName.toLowerCase().equals("user") && this.lastTweetValues.size() > 0) {
            this.userAccountValues.put("USERACCOUNT_LAST_TWEET", new Tweet(this.lastTweetValues));
        }
    }

    public UserAccount[] getParsedUserAccounts() {
        Object[] users = new UserAccount[this.usersList.size()];
        this.usersList.copyInto(users);
        return users;
    }

    public void loadParsedUserAccount(UserAccount user, int index) {
        user.setData((Hashtable)this.usersHashList.elementAt(index));
    }

    public long getNextCursorIndex() {
        return this.nextCursorIndex;
    }

    public long getPreviousCursorIndex() {
        return this.prevCursorIndex;
    }
}

