/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.model.Cursor;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.Credential;
import com.twitterapime.rest.FriendshipManager;
import com.twitterapime.rest.List;
import com.twitterapime.rest.ListManager;
import com.twitterapime.rest.RateLimitStatus;
import com.twitterapime.rest.Timeline;
import com.twitterapime.rest.TweetER;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.RateLimitStatusHandler;
import com.twitterapime.rest.handler.json.UserJSONHandler;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.xauth.Token;
import com.twitterapime.xauth.XAuthSigner;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class UserAccountManager {
    private static Hashtable userAccountMngrPoll;
    private static final Hashtable SERVICES_URL;
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS = "TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS";
    public static final String TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN = "TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN";
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS = "TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS";
    public static final String TWITTER_API_URL_SERVICE_USERS_SHOW = "TWITTER_API_URL_SERVICE_USERS_SHOW";
    public static final String TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE = "TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE";
    public static final String TWITTER_API_URL_SERVICE_REPORT_SPAM = "TWITTER_API_URL_SERVICE_REPORT_SPAM";
    public static final String TWITTER_API_URL_SERVICE_USERS_SEARCH = "TWITTER_API_URL_SERVICE_USERS_SEARCH";
    public static final String TWITTER_API_URL_SERVICE_USERS_LOOKUP = "TWITTER_API_URL_SERVICE_USERS_LOOKUP";
    private Credential credential;
    private boolean verified;
    private boolean invalidated;
    private Token token;
    private XAuthSigner signer;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized UserAccountManager getInstance(Credential c) {
        if (c == null) {
            throw new IllegalArgumentException("Credential must not be null.");
        }
        UserAccountManager uam = null;
        if (userAccountMngrPoll == null) {
            userAccountMngrPoll = new Hashtable();
        } else {
            Hashtable hashtable = userAccountMngrPoll;
            synchronized (hashtable) {
                uam = (UserAccountManager)userAccountMngrPoll.get(c);
            }
        }
        return uam != null ? uam : new UserAccountManager(c);
    }

    private UserAccountManager(Credential c) {
        this.credential = c;
        this.signer = new XAuthSigner(c.getString("CREDENTIAL_CONSUMER_KEY"), c.getString("CREDENTIAL_CONSUMER_SECRET"));
    }

    public RateLimitStatus getRateLimitStatus() throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS));
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getDefaultParser();
            RateLimitStatusHandler handler = new RateLimitStatusHandler();
            parser.parse(resp.getStream(), handler);
            RateLimitStatus rateLimitStatus = handler.getParsedRateLimitStatus();
            return rateLimitStatus;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean isVerified() {
        this.checkValid();
        return this.verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean verifyCredential() throws IOException, LimitExceededException {
        HttpResponse resp;
        HttpRequest req;
        block17: {
            this.checkValid();
            if (this.verified) {
                return true;
            }
            this.token = this.credential.getAccessToken();
            if (this.token == null) {
                req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN));
                this.signer.signForAccessToken(req, this.credential.getUsernameOrEmail(), this.credential.getString("CREDENTIAL_PASSWORD"));
                try {
                    resp = req.send();
                    if (resp.getCode() == 200) {
                        this.token = Token.parse(resp.getBodyContent());
                        break block17;
                    }
                    if (resp.getCode() == 401) {
                        boolean bl = false;
                        return bl;
                    }
                    HttpResponseCodeInterpreter.perform(resp);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    req.close();
                }
            }
        }
        req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS));
        try {
            resp = req.send();
            if (resp.getCode() == 200) {
                UserJSONHandler handler = new UserJSONHandler();
                Parser parser = ParserFactory.getParser(2);
                parser.parse(resp.getStream(), handler);
                UserAccount ua = handler.getParsedUserAccounts()[0];
                this.credential.setUsername(ua.getString("USERACCOUNT_USER_NAME"));
                this.verified = true;
                this.saveSelfOnPool();
                boolean bl = true;
                return bl;
            }
            if (resp.getCode() == 401) {
                this.token = null;
                boolean bl = false;
                return bl;
            }
            HttpResponseCodeInterpreter.perform(resp);
            boolean bl = false;
            return bl;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public Token getAccessToken() {
        return this.token;
    }

    public synchronized void signOut() throws IOException, LimitExceededException {
        this.checkValid();
        if (this.verified) {
            this.verified = false;
            this.token = null;
            this.signer = null;
            userAccountMngrPoll.remove(this.credential);
            Timeline.cleanPool();
            TweetER.cleanPool();
            FriendshipManager.cleanPool();
            ListManager.cleanPool();
            this.invalidated = true;
        }
    }

    public UserAccount getUserAccount() throws IOException, LimitExceededException {
        return this.getUserAccount(new UserAccount(this.credential.getString("CREDENTIAL_USERNAME")));
    }

    public UserAccount getUserAccount(UserAccount user) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        user.validateUserNameOrID();
        String[] pv = user.getUserNameOrIDParamValue();
        String param = "?" + pv[0] + "=" + pv[1];
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_USERS_SHOW) + param);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedUserAccount(user, 0);
            UserAccount userAccount = user;
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public UserAccount follow(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).follow(ua);
    }

    public UserAccount unfollow(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).unfollow(ua);
    }

    public boolean isFollowing(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isFollowing(ua);
    }

    public UserAccount block(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).block(ua);
    }

    public UserAccount unblock(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).unblock(ua);
    }

    public boolean isBlocking(UserAccount ua) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isBlocking(ua);
    }

    public String[] getFriendsID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFriendsID(query);
    }

    public String[] getFollowersID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFollowersID(query);
    }

    public Cursor getFriendsIDs(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFriendsIDs(query);
    }

    public Cursor getFollowersIDs(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getFollowersIDs(query);
    }

    public String[] getIncomingFollowersID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getIncomingFollowersID(query);
    }

    public String[] getOutgoingFriendsID(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).getOutgoingFriendsID(query);
    }

    public List[] getLists() throws IOException, LimitExceededException {
        this.checkValid();
        return ListManager.getInstance(this).getLists();
    }

    public List[] getListSubscriptions() throws IOException, LimitExceededException {
        this.checkValid();
        return ListManager.getInstance(this).getSubscriptions();
    }

    public UserAccount updateProfile(UserAccount newUserInfo) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (newUserInfo == null) {
            throw new IllegalArgumentException("New user info must not be null.");
        }
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE));
        req.setMethod("POST");
        String info = newUserInfo.getString("USERACCOUNT_NAME");
        if (info != null) {
            if (info.length() > 20) {
                throw new IllegalArgumentException("Name must not be longer than 20 characters.");
            }
            req.setBodyParameter("name", info);
        }
        if ((info = newUserInfo.getString("USERACCOUNT_DESCRIPTION")) != null) {
            if (info.length() > 160) {
                throw new IllegalArgumentException("Description must not be longer than 160 characters.");
            }
            req.setBodyParameter("description", info);
        }
        if ((info = newUserInfo.getString("USERACCOUNT_URL")) != null) {
            if (info.length() > 100) {
                throw new IllegalArgumentException("Url must not be longer than 100 characters.");
            }
            req.setBodyParameter("url", info);
        }
        if ((info = newUserInfo.getString("USERACCOUNT_LOCATION")) != null) {
            if (info.length() > 30) {
                throw new IllegalArgumentException("Location must not be longer than 30 characters.");
            }
            req.setBodyParameter("location", info);
        }
        if (req.getBodyParameters().size() == 0) {
            throw new IllegalArgumentException("New user info must not be empty.");
        }
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedUserAccount(newUserInfo, 0);
            UserAccount userAccount = newUserInfo;
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public UserAccount reportSpam(UserAccount user) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        user.validateUserNameOrID();
        String[] pv = user.getUserNameOrIDParamValue();
        String param = "?" + pv[0] + "=" + pv[1] + "&include_entities=true";
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_REPORT_SPAM) + param);
        req.setMethod("POST");
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            handler.loadParsedUserAccount(user, 0);
            UserAccount userAccount = user;
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public UserAccount[] search(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        if (query.toString().indexOf("q=") == -1) {
            throw new IllegalArgumentException("QueryComposer#query(String) is required.");
        }
        String url = this.getURL(TWITTER_API_URL_SERVICE_USERS_SEARCH);
        url = url + "?" + query.toString();
        HttpRequest req = this.createRequest(url);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            UserAccount[] userAccountArray = handler.getParsedUserAccounts();
            return userAccountArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean isFollowedBy(UserAccount user) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isFollowedBy(user);
    }

    public boolean isEnabledToSendDMTo(UserAccount user) throws IOException, LimitExceededException {
        this.checkValid();
        return FriendshipManager.getInstance(this).isEnabledToSendDMTo(user);
    }

    public UserAccount[] lookup(Query query) throws IOException, LimitExceededException {
        this.checkValid();
        this.checkVerified();
        if (query == null) {
            throw new IllegalArgumentException("Query must not be null.");
        }
        String qryStr = query.toString();
        if (qryStr.indexOf("user_id=") == -1 && qryStr.indexOf("screen_name=") == -1) {
            throw new IllegalArgumentException("QueryComposer#userIDs(String[]) or QueryComposer#screenNames(String[]) is required.");
        }
        HttpRequest req = this.createRequest(this.getURL(TWITTER_API_URL_SERVICE_USERS_LOOKUP));
        req.setMethod("POST");
        Hashtable params = HttpRequest.getQueryStringParams(qryStr);
        Enumeration keys = params.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            req.setBodyParameter(key, params.get(key).toString());
        }
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            UserAccount[] userAccountArray = handler.getParsedUserAccounts();
            return userAccountArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof UserAccountManager)) {
            return false;
        }
        return this.credential.equals(((UserAccountManager)o).credential);
    }

    public int hashCode() {
        return this.credential.hashCode();
    }

    Credential getCredential() {
        return this.credential;
    }

    synchronized HttpRequest createRequest(String url) {
        HttpRequest req = new HttpRequest(url);
        req.setSigner(this.signer, this.token);
        return req;
    }

    private synchronized void checkValid() {
        if (this.invalidated) {
            throw new IllegalStateException("This instance is no longer valid. Get a new one!");
        }
    }

    private void checkVerified() {
        if (!this.verified) {
            throw new SecurityException("User's credentials have not been verified yet.");
        }
    }

    private synchronized void saveSelfOnPool() {
        if (userAccountMngrPoll.get(this.credential) == null) {
            userAccountMngrPoll.put(this.credential, this);
        }
    }

    static {
        SERVICES_URL = new Hashtable(8);
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_VERIFY_CREDENTIALS, "https://api.twitter.com/1.1/account/verify_credentials.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_OAUTH_ACCESS_TOKEN, "https://api.twitter.com/oauth/access_token");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_RATE_LIMIT_STATUS, "http://api.twitter.com/1/account/rate_limit_status.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_USERS_SHOW, "https://api.twitter.com/1.1/users/show.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_ACCOUNT_UPDATE_PROFILE, "https://api.twitter.com/1.1/account/update_profile.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_REPORT_SPAM, "https://api.twitter.com/1.1/users/report_spam.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_USERS_SEARCH, "https://api.twitter.com/1.1/users/search.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_USERS_LOOKUP, "https://api.twitter.com/1.1/users/lookup.json");
    }
}

