/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.List;
import com.twitterapime.rest.Timeline;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.rest.handler.json.ListJSONHandler;
import com.twitterapime.rest.handler.json.UserJSONHandler;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.search.SearchDeviceListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ListManager {
    private static final Hashtable SERVICES_URL = new Hashtable(12);
    private static Hashtable listsMngrPool;
    private static ListManager singleInstance;
    public static final String TWITTER_API_URL_SERVICE_USER_LISTS = "TWITTER_API_URL_SERVICE_USER_LISTS";
    public static final String TWITTER_API_URL_SERVICE_USER_LISTS_ID = "TWITTER_API_URL_SERVICE_USER_LISTS_ID";
    public static final String TWITTER_API_URL_SERVICE_USER_LISTS_MEMBERSHIPS = "TWITTER_API_URL_SERVICE_USER_LISTS_MEMBERSHIPS";
    public static final String TWITTER_API_URL_SERVICE_USER_LIST_ID_MEMBERS = "TWITTER_API_URL_SERVICE_USER_LIST_ID_MEMBERS";
    public static final String TWITTER_API_URL_SERVICE_USER_LISTS_SUBSCRIPTIONS = "TWITTER_API_URL_SERVICE_USER_LISTS_SUBSCRIPTIONS";
    public static final String TWITTER_API_URL_SERVICE_USER_LIST_ID_SUBSCRIBERS = "TWITTER_API_URL_SERVICE_USER_LIST_ID_SUBSCRIBERS";
    public static final String TWITTER_API_URL_SERVICE_LISTS_MEMBERS_DESTROY = "TWITTER_API_URL_SERVICE_LISTS_MEMBERS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_LISTS_MEMBERS = "TWITTER_API_URL_SERVICE_LISTS_MEMBERS";
    public static final String TWITTER_API_URL_SERVICE_LISTS_MEMBERS_CREATE = "TWITTER_API_URL_SERVICE_LISTS_MEMBERS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_DESTROY = "TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_CREATE = "TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS = "TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS";
    public static final String TWITTER_API_URL_SERVICE_LISTS_DESTROY = "TWITTER_API_URL_SERVICE_LISTS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_LISTS_UPDATE = "TWITTER_API_URL_SERVICE_LISTS_UPDATE";
    public static final String TWITTER_API_URL_SERVICE_LISTS_ALL = "TWITTER_API_URL_SERVICE_LISTS_ALL";
    public static final String TWITTER_API_URL_SERVICE_LISTS_CREATE = "TWITTER_API_URL_SERVICE_LISTS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_LISTS_MEMBERSHIPS = "TWITTER_API_URL_SERVICE_LISTS_MEMBERSHIPS";
    public static final String TWITTER_API_URL_SERVICE_LISTS = "TWITTER_API_URL_SERVICE_LISTS";
    private UserAccountManager userAccountMngr;

    static synchronized void cleanPool() {
        if (listsMngrPool != null) {
            Enumeration keys = listsMngrPool.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                ListManager value = (ListManager)listsMngrPool.get(key);
                if (value.userAccountMngr.isVerified()) continue;
                listsMngrPool.remove(key);
            }
        }
    }

    public static synchronized ListManager getInstance(UserAccountManager uam) {
        ListManager fsmr;
        if (uam == null) {
            throw new IllegalArgumentException("UserAccountManager must not be null.");
        }
        if (!uam.isVerified()) {
            throw new SecurityException("User's credential must be verified.");
        }
        if (listsMngrPool == null) {
            listsMngrPool = new Hashtable();
        }
        if ((fsmr = (ListManager)listsMngrPool.get(uam)) == null) {
            fsmr = new ListManager(uam);
            listsMngrPool.put(uam, fsmr);
        }
        return fsmr;
    }

    public static synchronized ListManager getInstance() {
        if (singleInstance == null) {
            singleInstance = new ListManager();
        }
        return singleInstance;
    }

    private ListManager() {
    }

    private ListManager(UserAccountManager uam) {
        this.userAccountMngr = uam;
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public List create(List list) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_NAME");
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_CREATE));
        req.setMethod("POST");
        req.setBodyParameter("name", list.getString("LIST_NAME"));
        if (!list.isEmpty("LIST_MODE")) {
            req.setBodyParameter("mode", list.getString("LIST_MODE"));
        }
        if (!list.isEmpty("LIST_DESCRIPTION")) {
            req.setBodyParameter("description", list.getString("LIST_DESCRIPTION"));
        }
        return this.processRequest(req)[0];
    }

    public List update(List list) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_UPDATE));
        req.setMethod("POST");
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        if (!list.isEmpty("LIST_NAME")) {
            req.setBodyParameter("name", list.getString("LIST_NAME"));
        }
        if (!list.isEmpty("LIST_MODE")) {
            req.setBodyParameter("mode", list.getString("LIST_MODE"));
        }
        if (!list.isNull("LIST_DESCRIPTION")) {
            req.setBodyParameter("description", list.getString("LIST_DESCRIPTION"));
        }
        return this.processRequest(req)[0];
    }

    public List delete(List list) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_DESTROY));
        req.setMethod("POST");
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        return this.processRequest(req)[0];
    }

    public List[] getMemberships() throws IOException, LimitExceededException {
        return this.getMemberships(this.getUserAccountFromCredential());
    }

    public List[] getMemberships(UserAccount user) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        try {
            user.checkEmpty("USERACCOUNT_ID");
        }
        catch (IllegalArgumentException e) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
        }
        String[] usrp = user.getUserNameOrIDParamValue();
        String url = this.getURL(TWITTER_API_URL_SERVICE_LISTS_MEMBERSHIPS);
        url = url + "?" + usrp[0] + "=" + usrp[1];
        HttpRequest req = this.userAccountMngr.createRequest(url);
        return this.processRequest(req);
    }

    public List[] getSubscriptions() throws IOException, LimitExceededException {
        return this.getSubscriptions(this.getUserAccountFromCredential());
    }

    public List[] getSubscriptions(UserAccount user) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        try {
            user.checkEmpty("USERACCOUNT_ID");
        }
        catch (IllegalArgumentException e) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
        }
        String[] usrp = user.getUserNameOrIDParamValue();
        String url = this.getURL(TWITTER_API_URL_SERVICE_LISTS_ALL);
        url = url + "?" + usrp[0] + "=" + usrp[1];
        HttpRequest req = this.userAccountMngr.createRequest(url);
        return this.processRequest(req);
    }

    public List subscribe(List list) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_CREATE));
        req.setMethod("POST");
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        return this.processRequest(req)[0];
    }

    public List unsubscribe(List list) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_DESTROY));
        req.setMethod("POST");
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        return this.processRequest(req)[0];
    }

    public List addMember(List list, UserAccount user) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        list.checkEmpty("LIST_ID");
        try {
            user.checkEmpty("USERACCOUNT_ID");
        }
        catch (IllegalArgumentException e) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
        }
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_MEMBERS_CREATE));
        req.setMethod("POST");
        String[] usrp = user.getUserNameOrIDParamValue();
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        req.setBodyParameter(usrp[0], usrp[1]);
        return this.processRequest(req)[0];
    }

    public List removeMember(List list, UserAccount user) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        list.checkEmpty("LIST_ID");
        try {
            user.checkEmpty("USERACCOUNT_ID");
        }
        catch (IllegalArgumentException e) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
        }
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(TWITTER_API_URL_SERVICE_LISTS_MEMBERS_DESTROY));
        req.setMethod("POST");
        String[] usrp = user.getUserNameOrIDParamValue();
        req.setBodyParameter("list_id", list.getString("LIST_ID"));
        req.setBodyParameter(usrp[0], usrp[1]);
        return this.processRequest(req)[0];
    }

    public UserAccount[] getMembers(List list) throws IOException, LimitExceededException {
        return this.processMembersSubscribersRequest(list, TWITTER_API_URL_SERVICE_LISTS_MEMBERS);
    }

    public UserAccount[] getSubscribers(List list) throws IOException, LimitExceededException {
        return this.processMembersSubscribersRequest(list, TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS);
    }

    public List[] getLists() throws IOException, LimitExceededException {
        return this.getLists(this.getUserAccountFromCredential());
    }

    public List[] getLists(UserAccount user) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        try {
            user.checkEmpty("USERACCOUNT_ID");
        }
        catch (IllegalArgumentException e) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
        }
        String[] usrp = user.getUserNameOrIDParamValue();
        String url = this.getURL(TWITTER_API_URL_SERVICE_LISTS);
        url = url + "?" + usrp[0] + "=" + usrp[1];
        HttpRequest req = this.userAccountMngr.createRequest(url);
        return this.processRequest(req);
    }

    public void startGetListTweets(List list, Query q, SearchDeviceListener l) {
        this.checkUserAuth();
        Timeline tml = Timeline.getInstance(this.userAccountMngr);
        tml.startGetListTweets(list, q, l);
    }

    private UserAccount getUserAccountFromCredential() {
        return new UserAccount(this.userAccountMngr.getCredential().getString("CREDENTIAL_USERNAME"));
    }

    private List[] processRequest(HttpRequest req) throws IOException, LimitExceededException {
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            ListJSONHandler handler = new ListJSONHandler();
            parser.parse(resp.getStream(), handler);
            List[] listArray = handler.getParsedLists();
            return listArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private UserAccount[] processMembersSubscribersRequest(List list, String urlKey) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        String url = this.getURL(urlKey) + "?skip_status=true&list_id=" + list.getString("LIST_ID");
        HttpRequest req = this.userAccountMngr.createRequest(url);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            UserAccount[] userAccountArray = handler.getParsedUserAccounts();
            return userAccountArray;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    private void checkUserAuth() {
        if (this.userAccountMngr == null || !this.userAccountMngr.isVerified()) {
            throw new SecurityException("User's credential must be entered to perform this operation.");
        }
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_MEMBERS_DESTROY, "https://api.twitter.com/1.1/lists/members/destroy.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_MEMBERS, "https://api.twitter.com/1.1/lists/members.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_MEMBERS_CREATE, "https://api.twitter.com/1.1/lists/members/create.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_DESTROY, "https://api.twitter.com/1.1/lists/subscribers/destroy.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS_CREATE, "https://api.twitter.com/1.1/lists/subscribers/create.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_SUBSCRIBERS, "https://api.twitter.com/1.1/lists/subscribers.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_DESTROY, "https://api.twitter.com/1.1/lists/destroy.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_UPDATE, "https://api.twitter.com/1.1/lists/update.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_ALL, "http://api.twitter.com/1.1/lists/list.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_CREATE, "https://api.twitter.com/1.1/lists/create.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_MEMBERSHIPS, "https://api.twitter.com/1.1/lists/memberships.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS, "https://api.twitter.com/1.1/lists/list.json");
    }
}

