/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.model.Cursor;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.Credential;
import com.twitterapime.rest.Friendship;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.rest.handler.FriendshipHandler;
import com.twitterapime.rest.handler.json.UserIdJSONHandler;
import com.twitterapime.rest.handler.json.UserJSONHandler;
import com.twitterapime.search.InvalidQueryException;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.search.Query;
import com.twitterapime.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class FriendshipManager {
    private static final Hashtable SERVICES_URL = new Hashtable(13);
    private static Hashtable friendsMngrPool;
    private static FriendshipManager singleInstance;
    public static final String TWITTER_API_URL_SERVICE_FRIENDS_ID = "TWITTER_API_URL_SERVICE_FRIENDS_ID";
    public static final String TWITTER_API_URL_SERVICE_FOLLOWERS_ID = "TWITTER_API_URL_SERVICE_FOLLOWERS_ID";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_INCOMING = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_INCOMING";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_OUTGOING = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_OUTGOING";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_CREATE = "TWITTER_API_URL_SERVICE_BLOCKS_CREATE";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_DESTROY = "TWITTER_API_URL_SERVICE_BLOCKS_DESTROY";
    public static final String TWITTER_API_URL_SERVICE_BLOCKS_EXISTS = "TWITTER_API_URL_SERVICE_BLOCKS_EXISTS";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_FRIENDS = "TWITTER_API_URL_SERVICE_STATUSES_FRIENDS";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_FOLLOWERS = "TWITTER_API_URL_SERVICE_STATUSES_FOLLOWERS";
    public static final String TWITTER_API_URL_SERVICE_FRIENDSHIPS_SHOW = "TWITTER_API_URL_SERVICE_FRIENDSHIPS_SHOW";
    private UserAccountManager userAccountMngr;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    static synchronized void cleanPool() {
        if (friendsMngrPool != null) {
            Enumeration keys = friendsMngrPool.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                FriendshipManager value = (FriendshipManager)friendsMngrPool.get(key);
                if (value.userAccountMngr.isVerified()) continue;
                friendsMngrPool.remove(key);
            }
        }
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public static synchronized FriendshipManager getInstance(UserAccountManager uam) {
        FriendshipManager fsmr;
        if (uam == null) {
            throw new IllegalArgumentException("UserAccountManager must not be null.");
        }
        if (!uam.isVerified()) {
            throw new SecurityException("User's credential must be verified.");
        }
        if (friendsMngrPool == null) {
            friendsMngrPool = new Hashtable();
        }
        if ((fsmr = (FriendshipManager)friendsMngrPool.get(uam)) == null) {
            fsmr = new FriendshipManager(uam);
            friendsMngrPool.put(uam, fsmr);
        }
        return fsmr;
    }

    public static synchronized FriendshipManager getInstance() {
        if (singleInstance == null) {
            singleInstance = new FriendshipManager();
        }
        return singleInstance;
    }

    private FriendshipManager() {
    }

    private FriendshipManager(UserAccountManager uam) {
        this.userAccountMngr = uam;
    }

    public String[] getFriendsID(Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDS_ID), this.userAccountMngr.getUserAccount(), query);
    }

    public String[] getFriendsID(UserAccount user, Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDS_ID), user, query);
    }

    public String[] getFollowersID(Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FOLLOWERS_ID), this.userAccountMngr.getUserAccount(), query);
    }

    public String[] getFollowersID(UserAccount user, Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FOLLOWERS_ID), user, query);
    }

    public Cursor getFriendsIDs(Query query) throws IOException, LimitExceededException {
        return this.getFriendsIDsOrFollowersIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDS_ID), query);
    }

    public Cursor getFollowersIDs(Query query) throws IOException, LimitExceededException {
        return this.getFriendsIDsOrFollowersIDs(this.getURL(TWITTER_API_URL_SERVICE_FOLLOWERS_ID), query);
    }

    public Cursor getFriends(Query query) throws IOException, LimitExceededException {
        return this.getFriendsOrFollowers(this.getURL(TWITTER_API_URL_SERVICE_STATUSES_FRIENDS), query);
    }

    public Cursor getFollowers(Query query) throws IOException, LimitExceededException {
        return this.getFriendsOrFollowers(this.getURL(TWITTER_API_URL_SERVICE_STATUSES_FOLLOWERS), query);
    }

    public UserAccount follow(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE, ua);
    }

    public UserAccount unfollow(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY, ua);
    }

    public boolean isFollowing(UserAccount ua) throws IOException, LimitExceededException {
        Friendship friendship = this.getFriendship(ua).getSource();
        return friendship.getBoolean("FRIENDSHIP_FOLLOWING");
    }

    public UserAccount block(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_BLOCKS_CREATE, ua);
    }

    public UserAccount unblock(UserAccount ua) throws IOException, LimitExceededException {
        return this.manageFriendship(TWITTER_API_URL_SERVICE_BLOCKS_DESTROY, ua);
    }

    public boolean isBlocking(UserAccount ua) throws IOException, LimitExceededException {
        Friendship friendship = this.getFriendship(ua).getSource();
        return friendship.getBoolean("FRIENDSHIP_BLOCKING");
    }

    public String[] getIncomingFollowersID(Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDSHIPS_INCOMING), this.userAccountMngr.getUserAccount(), query);
    }

    public String[] getOutgoingFriendsID(Query query) throws IOException, LimitExceededException {
        return this.retrieveIDs(this.getURL(TWITTER_API_URL_SERVICE_FRIENDSHIPS_OUTGOING), this.userAccountMngr.getUserAccount(), query);
    }

    public Friendship getFriendship(UserAccount target) throws IOException, LimitExceededException {
        this.checkUserAuth();
        Credential c = this.userAccountMngr.getCredential();
        String username = c.getString("CREDENTIAL_USERNAME");
        return this.getFriendship(new UserAccount(username), target);
    }

    public Friendship getFriendship(UserAccount source, UserAccount target) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (source == null) {
            throw new IllegalArgumentException("Source must not me null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target must not me null.");
        }
        source.validateUserNameOrID();
        target.validateUserNameOrID();
        String[] pvSrc = source.getUserNameOrIDParamValue();
        String[] pvTgt = target.getUserNameOrIDParamValue();
        pvSrc[0] = "user_id".equals(pvSrc[0]) ? "source_id" : "source_screen_name";
        pvTgt[0] = "user_id".equals(pvTgt[0]) ? "target_id" : "target_screen_name";
        String url = this.getURL(TWITTER_API_URL_SERVICE_FRIENDSHIPS_SHOW);
        url = url + "?" + pvSrc[0] + "=" + pvSrc[1] + "&" + pvTgt[0] + "=" + pvTgt[1];
        HttpRequest req = this.userAccountMngr.createRequest(url);
        try {
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            FriendshipHandler handler = new FriendshipHandler();
            parser.parse(resp.getStream(), handler);
            Friendship friendship = handler.getParsedFriendship();
            return friendship;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    public boolean isFollowedBy(UserAccount user) throws IOException, LimitExceededException {
        Friendship details = this.getFriendship(user).getSource();
        String followedBy = details.getString("FRIENDSHIP_FOLLOWED_BY");
        return followedBy != null && "true".equals(followedBy);
    }

    public boolean isEnabledToSendDMTo(UserAccount user) throws IOException, LimitExceededException {
        Friendship details = this.getFriendship(user).getSource();
        String canSendDM = details.getString("FRIENDSHIP_CAN_DM");
        return canSendDM != null && "true".equals(canSendDM);
    }

    private UserAccount manageFriendship(String servURLKey, UserAccount ua) throws IOException, LimitExceededException {
        if (ua == null) {
            throw new IllegalArgumentException("UserAccount object must not me null.");
        }
        ua.validateUserNameOrID();
        this.checkUserAuth();
        String[] pv = ua.getUserNameOrIDParamValue();
        HttpRequest req = this.userAccountMngr.createRequest(this.getURL(servURLKey));
        req.setMethod("POST");
        req.setBodyParameter(pv[0], pv[1]);
        try {
            HttpResponse resp = req.send();
            if (resp.getCode() == 403) {
                throw new InvalidQueryException(HttpResponseCodeInterpreter.getErrorMessage(resp));
            }
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            UserAccount userAccount = handler.getParsedUserAccounts()[0];
            return userAccount;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private Cursor getFriendsOrFollowers(String url, Query query) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("Url must not be null/empty.");
        }
        if (query != null) {
            url = url + "?" + query.toString();
        }
        HttpRequest req = this.userAccountMngr.createRequest(url);
        try {
            Cursor cursor;
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserJSONHandler handler = new UserJSONHandler();
            parser.parse(resp.getStream(), handler);
            Cursor cursor2 = cursor = new Cursor(handler.getParsedUserAccounts(), handler.getPreviousCursorIndex(), handler.getNextCursorIndex());
            return cursor2;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private Cursor getFriendsIDsOrFollowersIDs(String url, Query query) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("Url must not be null/empty.");
        }
        if (query != null) {
            url = url + "?" + query.toString();
        }
        HttpRequest req = this.userAccountMngr.createRequest(url);
        try {
            Cursor cursor;
            HttpResponse resp = req.send();
            HttpResponseCodeInterpreter.perform(resp);
            Parser parser = ParserFactory.getParser(2);
            UserIdJSONHandler handler = new UserIdJSONHandler();
            parser.parse(resp.getStream(), handler);
            Cursor cursor2 = cursor = new Cursor(handler.getParsedIds(), handler.getPreviousCursorIndex(), handler.getNextCursorIndex());
            return cursor2;
        }
        catch (ParserException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            req.close();
        }
    }

    private String[] retrieveIDs(String url, UserAccount user, Query query) throws IOException, LimitExceededException {
        this.checkUserAuth();
        if (user == null) {
            throw new IllegalArgumentException("User must not be null.");
        }
        user.validateUserNameOrID();
        String[] pv = user.getUserNameOrIDParamValue();
        url = url + "?" + pv[0] + "=" + pv[1];
        long maxCount = Long.MAX_VALUE;
        if (query != null) {
            maxCount = Long.parseLong(StringUtil.split(query.toString(), '=')[1]);
        }
        long loadedCount = 0L;
        long cursorNextIdx = -1L;
        Vector<String> idsList = new Vector<String>(20);
        UserIdJSONHandler handler = new UserIdJSONHandler(maxCount);
        Parser parser = ParserFactory.getParser(2);
        do {
            HttpRequest req = this.userAccountMngr.createRequest(url + "&cursor=" + cursorNextIdx);
            try {
                HttpResponse resp = req.send();
                HttpResponseCodeInterpreter.perform(resp);
                parser.parse(resp.getStream(), handler);
                String[] ids = handler.getParsedIds();
                for (int i = 0; i < ids.length; ++i) {
                    idsList.addElement(ids[i]);
                    ++loadedCount;
                }
                cursorNextIdx = handler.getNextCursorIndex();
                handler.clear();
            }
            catch (ParserException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                req.close();
            }
        } while (loadedCount < maxCount && cursorNextIdx != 0L);
        Object[] ids = new String[idsList.size()];
        idsList.copyInto(ids);
        return ids;
    }

    private void checkUserAuth() {
        if (this.userAccountMngr == null || !this.userAccountMngr.isVerified()) {
            throw new SecurityException("User's credential must be entered to perform this operation.");
        }
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDS_ID, "https://api.twitter.com/1.1/friends/ids.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FOLLOWERS_ID, "https://api.twitter.com/1.1/followers/ids.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_CREATE, "https://api.twitter.com/1.1/friendships/create.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_DESTROY, "https://api.twitter.com/1.1/friendships/destroy.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_EXISTS, "http://api.twitter.com/1/friendships/exists.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_INCOMING, "https://api.twitter.com/1.1/friendships/incoming.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_OUTGOING, "https://api.twitter.com/1.1/friendships/outgoing.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_CREATE, "https://api.twitter.com/1.1/blocks/create.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_DESTROY, "https://api.twitter.com/1.1/blocks/destroy.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_BLOCKS_EXISTS, "http://api.twitter.com/1/blocks/exists/");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_FRIENDS, "https://api.twitter.com/1.1/friends/list.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_FOLLOWERS, "https://api.twitter.com/1.1/followers/list.json");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FRIENDSHIPS_SHOW, "https://api.twitter.com/1.1/friendships/show.json");
    }
}

