/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.parser;

import com.twitterapime.parser.JSONArray;
import com.twitterapime.parser.JSONHandler;
import com.twitterapime.parser.JSONObject;
import com.twitterapime.parser.ParserException;
import com.twitterapime.util.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultJSONHandler
implements JSONHandler {
    protected Hashtable content;
    protected String startKey;

    public DefaultJSONHandler(String startKey) {
        this.startKey = startKey;
    }

    public void handle(JSONObject jsonObj) throws ParserException {
        this.content = this.readJSON(jsonObj.getJSONObject(this.startKey), new Hashtable());
    }

    public Hashtable getParsedContent() {
        return this.content;
    }

    public boolean isMember(JSONObject jsonObj, String key) throws ParserException {
        return jsonObj.getString(key).startsWith("{");
    }

    public boolean isArray(JSONObject jsonObj, String key) throws ParserException {
        return jsonObj.getString(key).startsWith("[");
    }

    protected Hashtable readJSON(JSONObject jsonObj, Hashtable data) throws ParserException {
        Enumeration keys = jsonObj.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (this.isMember(jsonObj, key)) {
                data.put(key, this.readJSON(jsonObj.getJSONObject(key), new Hashtable()));
                continue;
            }
            if (this.isArray(jsonObj, key)) {
                JSONArray array = jsonObj.getJSONArray(key);
                Hashtable[] arrayObj = new Hashtable[array.length()];
                for (int i = 0; i < arrayObj.length; ++i) {
                    arrayObj[i] = this.readJSON(array.getJSONObject(i), new Hashtable());
                }
                data.put(key, arrayObj);
                continue;
            }
            data.put(key, jsonObj.getString(key));
        }
        return data;
    }

    protected void replaceProperty(Hashtable hashtable, String searchKey, String replacementKey) {
        Object value = hashtable.get(searchKey);
        if (value != null) {
            String str;
            hashtable.remove(searchKey);
            if (value instanceof String && (StringUtil.isEmpty(str = value.toString()) || "null".equals(str))) {
                return;
            }
            hashtable.put(replacementKey, value);
        }
    }

    protected boolean isEmpty(String str) {
        return StringUtil.isEmpty(str) || "null".equals(str.trim());
    }
}

