/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.io;

import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.handler.json.HttpResponseCodeErrorJSONHandler;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.search.InvalidQueryException;
import com.twitterapime.search.LimitExceededException;
import com.twitterapime.util.StringUtil;
import java.io.IOException;

public final class HttpResponseCodeInterpreter {
    public static final int CUSTOM_HTTP_CODE_ENHANCE_YOUR_CALM = 420;

    public static void perform(HttpResponse response) throws IOException, LimitExceededException {
        if (response == null) {
            throw new IllegalArgumentException("Response must not be null.");
        }
        int respCode = response.getCode();
        if (respCode != 200 && respCode != 304) {
            if (HttpResponseCodeInterpreter.isInvalidQueryError(respCode)) {
                throw new InvalidQueryException(HttpResponseCodeInterpreter.getErrorMessage(response));
            }
            if (HttpResponseCodeInterpreter.isLimitExceededError(respCode)) {
                String emgs = HttpResponseCodeInterpreter.getErrorMessage(response);
                String raft = response.getResponseField("X-Rate-Limit-Reset");
                if (!StringUtil.isEmpty(raft)) {
                    emgs = emgs + " / Retry after " + raft + " secs.";
                }
                throw new LimitExceededException(emgs);
            }
            if (HttpResponseCodeInterpreter.isSecurityError(respCode)) {
                throw new SecurityException(HttpResponseCodeInterpreter.getErrorMessage(response));
            }
            throw new IOException(HttpResponseCodeInterpreter.getErrorMessage(response));
        }
    }

    public static String getErrorMessage(HttpResponse response) throws IOException {
        String errorMsg = null;
        Parser parser = ParserFactory.getParser(2);
        HttpResponseCodeErrorJSONHandler handler = new HttpResponseCodeErrorJSONHandler();
        try {
            parser.parse(response.getStream(), handler);
            errorMsg = handler.getMessage();
        }
        catch (Exception e) {
            errorMsg = "HTTP ERROR CODE: " + response.getCode();
        }
        return errorMsg;
    }

    static boolean isLimitExceededError(int code) {
        return code == 429 || code == 400 || code == 403 || code == 420;
    }

    static boolean isInvalidQueryError(int code) {
        return code == 404 || code == 406;
    }

    static boolean isServiceError(int code) {
        return code == 502 || code == 500 || code == 503;
    }

    static boolean isSecurityError(int code) {
        return code == 401;
    }

    private HttpResponseCodeInterpreter() {
    }
}

