/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.io;

import com.twitterapime.io.HttpConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public final class HttpResponse {
    private int code;
    private String body;
    private InputStream stream;
    private HttpConnection conn;

    HttpResponse(HttpConnection conn) throws IOException {
        this.conn = conn;
        this.code = conn.getResponseCode();
        this.stream = conn.openInputStream();
    }

    public boolean wasSuccessful() {
        return this.code >= 200 && this.code < 400;
    }

    public String getBodyContent() throws IOException {
        return this.body != null ? this.body : (this.body = this.parseBody(this.stream));
    }

    public InputStream getStream() {
        return this.stream;
    }

    public int getCode() {
        return this.code;
    }

    public String getResponseField(String key) throws IOException {
        return this.conn.getRequestProperty(key);
    }

    private String parseBody(InputStream in) throws IOException {
        int n;
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        while ((n = in.read(buffer)) > 0) {
            out.write(buffer, 0, n);
        }
        try {
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
    }
}

