/*
 * Decompiled with CFR 0.152.
 */
package impl.javame.com.twitterapime.parser;

import com.twitterapime.parser.Handler;
import com.twitterapime.parser.JSONHandler;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserException;
import impl.javame.com.twitterapime.parser.JSONOrgObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public final class JSONOrgParser
extends Parser {
    public void parse(InputStream in, Handler handler) throws IOException, ParserException {
        if (!(handler instanceof JSONHandler)) {
            throw new IllegalArgumentException("Handler object must implement JSONHandler.");
        }
        try {
            JSONHandler hdlr = (JSONHandler)handler;
            JSONObject outer = new JSONObject(this.streamToString(in));
            hdlr.handle(new JSONOrgObject(outer));
        }
        catch (ParserException e) {
            throw new ParserException(e.getMessage());
        }
        catch (JSONException e) {
            throw new ParserException(e.getMessage());
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage());
        }
    }

    private String streamToString(InputStream stream) throws IOException {
        int c;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = stream.read()) != -1) {
            out.write(c);
        }
        String json = new String(out.toByteArray(), "UTF-8");
        if (json.startsWith("[")) {
            json = json.substring(1, json.length() - 1);
            json = "{\"root\": " + json + "}";
        }
        return json;
    }
}

