/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.xauth;

import com.twitterapime.util.StringUtil;

public final class Token {
    private String token;
    private String secret;
    private String userId;
    private String username;

    public static Token parse(String tokenStr) {
        String access = StringUtil.getUrlParamValue(tokenStr, "oauth_token");
        String secret = StringUtil.getUrlParamValue(tokenStr, "oauth_token_secret");
        String userId = StringUtil.getUrlParamValue(tokenStr, "user_id");
        String username = StringUtil.getUrlParamValue(tokenStr, "screen_name");
        return new Token(access, secret, userId, username);
    }

    public Token(String token, String secret) {
        this(token, secret, null, null);
    }

    public Token(String token, String secret, String userId, String username) {
        if (StringUtil.isEmpty(token)) {
            throw new IllegalArgumentException("Token must not be empty/null");
        }
        if (StringUtil.isEmpty(secret)) {
            throw new IllegalArgumentException("Secret must not be empty/null");
        }
        this.token = token;
        this.secret = secret;
        this.userId = userId;
        this.username = username;
    }

    public String getToken() {
        return this.token;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "oauth_token=" + this.token + "&oauth_token_secret=" + this.secret + "&user_id=" + this.userId + "&screen_name=" + this.username;
    }
}

