/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.search.handler;

import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.search.TweetEntity;
import java.util.Hashtable;
import java.util.Vector;

public final class TweetEntityHandler
extends DefaultXMLHandler {
    private Hashtable userAccountData;
    private Hashtable urlData;
    private Hashtable mediaData;

    public void populate(Hashtable data, String path, String text) {
        if (path.endsWith("/user_mentions/user_mention/id")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_MENTIONS");
            this.userAccountData = new Hashtable();
            this.userAccountData.put("TWEETENTITY_USERACCOUNT_ID", text);
            v.addElement(new TweetEntity(this.userAccountData));
        } else if (path.endsWith("/user_mentions/user_mention/screen_name")) {
            if (this.userAccountData != null) {
                this.userAccountData.put("TWEETENTITY_USERACCOUNT_USER_NAME", text);
            }
        } else if (path.endsWith("/user_mentions/user_mention/name")) {
            if (this.userAccountData != null) {
                this.userAccountData.put("TWEETENTITY_USERACCOUNT_NAME", text);
            }
        } else if (path.endsWith("/urls/url/url")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_URLS");
            this.urlData = new Hashtable();
            this.urlData.put("TWEETENTITY_URL", text);
            v.addElement(new TweetEntity(this.urlData));
        } else if (path.endsWith("/urls/url/display_url")) {
            if (this.urlData != null) {
                this.urlData.put("TWEETENTITY_DISPLAY_URL", text);
            }
        } else if (path.endsWith("/urls/url/expanded_url")) {
            if (this.urlData != null) {
                this.urlData.put("TWEETENTITY_EXPANDED_URL", text);
            }
        } else if (path.endsWith("/media/creative/media_url")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_MEDIAS");
            this.mediaData = new Hashtable();
            this.mediaData.put("TWEETENTITY_MEDIA", text);
            v.addElement(new TweetEntity(this.mediaData));
        } else if (path.endsWith("/media/creative/display_url")) {
            if (this.mediaData != null) {
                this.mediaData.put("TWEETENTITY_DISPLAY_URL", text);
            }
        } else if (path.endsWith("/media/creative/url")) {
            if (this.mediaData != null) {
                this.mediaData.put("TWEETENTITY_URL", text);
            }
        } else if (path.endsWith("/hashtags/hashtag/text")) {
            Vector v = this.getOrCreateIfNecessary(data, "TWEETENTITY_HASHTAGS");
            Hashtable<String, String> t = new Hashtable<String, String>();
            t.put("TWEETENTITY_HASHTAG", text);
            v.addElement(new TweetEntity(t));
        }
    }

    private Vector getOrCreateIfNecessary(Hashtable data, String key) {
        Vector v = (Vector)data.get(key);
        if (v == null) {
            v = new Vector();
            data.put(key, v);
        }
        return v;
    }
}

