/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest.handler;

import com.twitterapime.parser.Attributes;
import com.twitterapime.parser.DefaultXMLHandler;
import com.twitterapime.parser.ParserException;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.handler.TweetHandler;
import com.twitterapime.rest.handler.UserAccountHandler;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.search.Tweet;
import java.util.Hashtable;
import java.util.Vector;

public final class DirectMessageHandler
extends DefaultXMLHandler {
    private UserAccountHandler uaHandler = new UserAccountHandler();
    private TweetHandler tHandler = new TweetHandler();
    private Vector dmList = new Vector(10);
    private Hashtable senderValues;
    private Hashtable recipientValues;
    private Hashtable dmValues;
    private SearchDeviceListener listener;

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws ParserException {
        super.startElement(namespaceURI, localName, qName, attrs);
        if (localName.toLowerCase().equals("direct_message")) {
            this.dmValues = new Hashtable(5);
            this.senderValues = new Hashtable(25);
            this.recipientValues = new Hashtable(25);
            this.dmValues.put("TWEET_USER_ACCOUNT", new UserAccount(this.senderValues));
            this.dmValues.put("TWEET_RECIPIENT_ACCOUNT", new UserAccount(this.recipientValues));
            this.dmList.addElement(new Tweet(this.dmValues));
        }
    }

    public void text(String text) throws ParserException {
        text = text.trim();
        if (this.xmlPath.indexOf("/direct_message/sender/") != -1) {
            this.uaHandler.populate(this.senderValues, this.xmlPath, text);
        } else if (this.xmlPath.indexOf("/direct_message/recipient/") != -1) {
            this.uaHandler.populate(this.recipientValues, this.xmlPath, text);
        } else if (this.xmlPath.indexOf("/direct_message/") != -1) {
            this.tHandler.populate(this.dmValues, this.xmlPath, text);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws ParserException {
        super.endElement(namespaceURI, localName, qName);
        if (localName.toLowerCase().equals("direct_message")) {
            this.fireTweetParsed((Tweet)this.dmList.lastElement());
        }
    }

    public Tweet[] getParsedTweets() {
        Object[] ts = new Tweet[this.dmList.size()];
        this.dmList.copyInto(ts);
        return ts;
    }

    public void loadParsedTweet(Tweet dm, int index) {
        dm.setData((Tweet)this.dmList.elementAt(index));
    }

    public void setSearchDeviceListener(SearchDeviceListener listener) {
        this.listener = listener;
    }

    private void fireTweetParsed(Tweet tweet) {
        if (this.listener != null) {
            this.listener.tweetFound(tweet);
        }
    }
}

