/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.io.HttpRequest;
import com.twitterapime.io.HttpResponse;
import com.twitterapime.io.HttpResponseCodeInterpreter;
import com.twitterapime.parser.Handler;
import com.twitterapime.parser.Parser;
import com.twitterapime.parser.ParserFactory;
import com.twitterapime.rest.List;
import com.twitterapime.rest.UserAccount;
import com.twitterapime.rest.UserAccountManager;
import com.twitterapime.rest.handler.DirectMessageHandler;
import com.twitterapime.rest.handler.TimelineHandler;
import com.twitterapime.search.Query;
import com.twitterapime.search.QueryComposer;
import com.twitterapime.search.SearchDeviceListener;
import com.twitterapime.util.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Timeline {
    private static final Hashtable SERVICES_URL = new Hashtable(11);
    private static Hashtable timelinePool;
    private static Timeline singleInstance;
    public static final String TWITTER_API_URL_SERVICE_STATUSES_PUBLIC_TIMELINE = "TWITTER_API_URL_SERVICE_STATUSES_PUBLIC_TIMELINE";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_HOME_TIMELINE = "TWITTER_API_URL_SERVICE_STATUSES_HOME_TIMELINE";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_USER_TIMELINE = "TWITTER_API_URL_SERVICE_STATUSES_USER_TIMELINE";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_MENTIONS = "TWITTER_API_URL_SERVICE_STATUSES_MENTIONS";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_RETWEETS_OF_ME = "TWITTER_API_URL_SERVICE_STATUSES_RETWEETS_OF_ME";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_BY_ME = "TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_BY_ME";
    public static final String TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_TO_ME = "TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_TO_ME";
    public static final String TWITTER_API_URL_SERVICE_DIRECT_MESSAGES = "TWITTER_API_URL_SERVICE_DIRECT_MESSAGES";
    public static final String TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_SENT = "TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_SENT";
    public static final String TWITTER_API_URL_SERVICE_USER_LISTS_STATUSES = "TWITTER_API_URL_SERVICE_USER_LISTS_STATUSES";
    public static final String TWITTER_API_URL_SERVICE_FAVORITES = "TWITTER_API_URL_SERVICE_FAVORITES";
    public static final String TWITTER_API_URL_SERVICE_LISTS_STATUSES = "TWITTER_API_URL_SERVICE_LISTS_STATUSES";
    private UserAccountManager userAccountMngr;

    private String getURL(String serviceKey) {
        return (String)SERVICES_URL.get(serviceKey);
    }

    static synchronized void cleanPool() {
        if (timelinePool != null) {
            Enumeration keys = timelinePool.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Timeline value = (Timeline)timelinePool.get(key);
                if (value.userAccountMngr.isVerified()) continue;
                timelinePool.remove(key);
            }
        }
    }

    public void setServiceURL(String serviceKey, String url) {
        SERVICES_URL.put(serviceKey, url);
    }

    public static synchronized Timeline getInstance(UserAccountManager uam) {
        Timeline ter;
        if (uam == null) {
            throw new IllegalArgumentException("UserAccountManager must not be null.");
        }
        if (!uam.isVerified()) {
            throw new SecurityException("User's credential must be verified.");
        }
        if (timelinePool == null) {
            timelinePool = new Hashtable();
        }
        if ((ter = (Timeline)timelinePool.get(uam)) == null) {
            ter = new Timeline(uam);
            timelinePool.put(uam, ter);
        }
        return ter;
    }

    public static synchronized Timeline getInstance() {
        if (singleInstance == null) {
            singleInstance = new Timeline();
        }
        return singleInstance;
    }

    private Timeline() {
    }

    private Timeline(UserAccountManager uam) {
        this.userAccountMngr = uam;
    }

    public void startGetPublicTweets(SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_PUBLIC_TIMELINE, QueryComposer.includeEntities(), l, h, false);
    }

    public void startGetHomeTweets(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_HOME_TIMELINE, q, l, h, true);
    }

    public void startGetUserTweets(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_USER_TIMELINE, q, l, h, true);
    }

    public void startGetMentions(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_MENTIONS, q, l, h, true);
    }

    public void startGetDirectMessages(Query q, boolean received, SearchDeviceListener l) {
        String urlKey = received ? TWITTER_API_URL_SERVICE_DIRECT_MESSAGES : TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_SENT;
        DirectMessageHandler h = new DirectMessageHandler();
        h.setSearchDeviceListener(l);
        this.startGet(urlKey, q, l, h, true);
    }

    public void startGetRetweetsByMe(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_BY_ME, q, l, h, true);
    }

    public void startGetRetweetsToMe(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_TO_ME, q, l, h, true);
    }

    public void startGetRetweetsOfMe(Query q, SearchDeviceListener l) {
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        this.startGet(TWITTER_API_URL_SERVICE_STATUSES_RETWEETS_OF_ME, q, l, h, true);
    }

    public void startGetListTweets(List list, Query q, SearchDeviceListener l) {
        if (list == null) {
            throw new IllegalArgumentException("List must not be null.");
        }
        list.checkEmpty("LIST_ID");
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        String url = this.getURL(TWITTER_API_URL_SERVICE_LISTS_STATUSES);
        Query qry = new Query("list_id=" + list.getString("LIST_ID"));
        q = q != null ? QueryComposer.append(qry, q) : qry;
        this.startGet(url, q, l, h, this.userAccountMngr != null);
    }

    public void startGetFavoriteTweets(Query q, SearchDeviceListener l) {
        this.checkUserAuth();
        String username = this.userAccountMngr.getCredential().getString("CREDENTIAL_USERNAME");
        this.startGetFavoriteTweets(new UserAccount(username), q, l);
    }

    public void startGetFavoriteTweets(UserAccount user, Query q, SearchDeviceListener l) {
        if (user == null) {
            throw new IllegalArgumentException("User must not be null");
        }
        String id = user.getString("USERACCOUNT_ID");
        if (StringUtil.isEmpty(id)) {
            user.checkEmpty("USERACCOUNT_USER_NAME");
            id = user.getString("USERACCOUNT_USER_NAME");
        }
        TimelineHandler h = new TimelineHandler();
        h.setSearchDeviceListener(l);
        String url = this.getURL(TWITTER_API_URL_SERVICE_FAVORITES);
        url = StringUtil.replace(url, ":id", id);
        this.startGet(url, q, l, h, false);
    }

    private void startGet(final String servURLKey, final Query q, final SearchDeviceListener l, final Handler h, boolean checkAuth) {
        if (servURLKey == null || servURLKey.trim().length() == 0) {
            throw new IllegalArgumentException("Url must not be empty/null.");
        }
        if (l == null) {
            throw new IllegalArgumentException("Listener must not be null.");
        }
        if (h == null) {
            throw new IllegalArgumentException("Handler must not be null.");
        }
        if (checkAuth) {
            this.checkUserAuth();
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String url = servURLKey;
                if (!servURLKey.startsWith("http")) {
                    url = Timeline.this.getURL(servURLKey);
                }
                url = q != null ? url + '?' + q.toString() : url;
                HttpRequest req = Timeline.this.userAccountMngr != null ? Timeline.this.userAccountMngr.createRequest(url) : new HttpRequest(url);
                try {
                    HttpResponse resp = req.send();
                    HttpResponseCodeInterpreter.perform(resp);
                    Parser parser = ParserFactory.getDefaultParser();
                    parser.parse(resp.getStream(), h);
                    l.searchCompleted();
                }
                catch (Exception e) {
                    l.searchFailed(e);
                }
                finally {
                    try {
                        req.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private void checkUserAuth() {
        if (this.userAccountMngr == null || !this.userAccountMngr.isVerified()) {
            throw new SecurityException("User's credential must be entered to perform this operation.");
        }
    }

    static {
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_PUBLIC_TIMELINE, "http://api.twitter.com/1/statuses/public_timeline.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_HOME_TIMELINE, "http://api.twitter.com/1/statuses/home_timeline.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_USER_TIMELINE, "http://api.twitter.com/1/statuses/user_timeline.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_MENTIONS, "http://api.twitter.com/1/statuses/mentions.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_DIRECT_MESSAGES, "http://api.twitter.com/1/direct_messages.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_DIRECT_MESSAGES_SENT, "http://api.twitter.com/1/direct_messages/sent.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_RETWEETS_OF_ME, "http://api.twitter.com/1/statuses/retweets_of_me.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_BY_ME, "http://api.twitter.com/1/statuses/retweeted_by_me.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_STATUSES_RETWEETED_TO_ME, "http://api.twitter.com/1/statuses/retweeted_to_me.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_FAVORITES, "http://api.twitter.com/1/favorites/:id.xml");
        SERVICES_URL.put(TWITTER_API_URL_SERVICE_LISTS_STATUSES, "http://api.twitter.com/1/lists/statuses.xml");
    }
}

