/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.rest;

import com.twitterapime.model.DefaultEntity;
import com.twitterapime.util.StringUtil;
import com.twitterapime.xauth.Token;
import java.util.Hashtable;

public final class Credential
extends DefaultEntity {
    public Credential(String usernameOrEmail, String password) {
        throw new IllegalArgumentException("This constructor is deprecated!");
    }

    public Credential(String usernameOrEmail, String password, String consumerKey, String consumerSecret) {
        if (StringUtil.isEmpty(usernameOrEmail)) {
            throw new IllegalArgumentException("Username or e-mail must not be empty/null");
        }
        if (StringUtil.isEmpty(password)) {
            throw new IllegalArgumentException("Password must not be empty/null");
        }
        if (StringUtil.isEmpty(consumerKey)) {
            throw new IllegalArgumentException("Consumer Key must not be empty/null");
        }
        if (StringUtil.isEmpty(consumerSecret)) {
            throw new IllegalArgumentException("Consumer Secret must not be empty/null");
        }
        Hashtable<String, String> credtls = new Hashtable<String, String>(4);
        if (usernameOrEmail.indexOf(64) != -1) {
            credtls.put("CREDENTIAL_EMAIL", usernameOrEmail);
        } else {
            credtls.put("CREDENTIAL_USERNAME", usernameOrEmail);
        }
        credtls.put("CREDENTIAL_PASSWORD", password);
        credtls.put("CREDENTIAL_CONSUMER_KEY", consumerKey);
        credtls.put("CREDENTIAL_CONSUMER_SECRET", consumerSecret);
        this.setData(credtls);
    }

    public Credential(String usernameOrEmail, String consumerKey, String consumerSecret, Token accessToken) {
        this(usernameOrEmail, "ignored", consumerKey, consumerSecret);
        if (accessToken == null) {
            throw new IllegalArgumentException("accessToken must not be null.");
        }
        this.data.put("CREDENTIAL_ACCESS_TOKEN", accessToken);
    }

    public Credential(String consumerKey, String consumerSecret, Token accessToken) {
        this("ignored", consumerKey, consumerSecret, accessToken);
    }

    Token getAccessToken() {
        return (Token)this.getObject("CREDENTIAL_ACCESS_TOKEN");
    }

    boolean hasUsername() {
        return this.data.get("CREDENTIAL_USERNAME") != null;
    }

    String getUsernameOrEmail() {
        String username = this.getString("CREDENTIAL_USERNAME");
        if (username == null) {
            username = this.getString("CREDENTIAL_EMAIL");
        }
        return username;
    }

    void setUsername(String username) {
        this.data.put("CREDENTIAL_USERNAME", username);
    }
}

