/*
 * Decompiled with CFR 0.152.
 */
package com.twitterapime.model;

import com.twitterapime.model.Entity;
import com.twitterapime.util.StringUtil;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultEntity
implements Entity {
    protected Hashtable data;

    public DefaultEntity() {
        this.setData((Hashtable)null);
    }

    public DefaultEntity(Hashtable data) {
        this.setData(data);
    }

    public final void setData(Hashtable data) {
        if (data == null) {
            data = new Hashtable();
        }
        this.data = data;
    }

    public final void setData(DefaultEntity e) {
        this.setData(e.data);
    }

    public final Object[] getArray(String attr) {
        return (Object[])this.getValue(attr, new Object[]{""}.getClass());
    }

    public final Date getDate(String attr) {
        Object v = this.getObject(attr);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v instanceof Long) {
            return new Date((Long)v);
        }
        if (v instanceof String) {
            return new Date(Long.parseLong(v.toString()));
        }
        throw new ClassCastException("Invalid type value: " + v.getClass().getName());
    }

    public final int getInt(String attr) {
        Object v = this.getObject(attr);
        if (v == null) {
            return Integer.MIN_VALUE;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return Integer.parseInt(v.toString());
        }
        if (v instanceof Long) {
            long dv = (Long)v;
            if (dv >= Integer.MIN_VALUE && dv <= Integer.MAX_VALUE) {
                return (int)dv;
            }
            throw new RuntimeException("Cannot convert to int due to loss of precision: " + dv);
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1 : 0;
        }
        throw new ClassCastException("Invalid type value: " + v.getClass().getName());
    }

    public final long getLong(String attr) {
        Object v = this.getObject(attr);
        if (v == null) {
            return Long.MIN_VALUE;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof Date) {
            return ((Date)v).getTime();
        }
        if (v instanceof String) {
            return Long.parseLong(v.toString());
        }
        if (v instanceof Integer) {
            return ((Integer)v).longValue();
        }
        if (v instanceof Boolean) {
            return (Boolean)v != false ? 1L : 0L;
        }
        throw new ClassCastException("Invalid type value: " + v.getClass().getName());
    }

    public final Object getObject(String attr) {
        return this.data.get(attr);
    }

    public final String getString(String attr) {
        Object v = this.data.get(attr);
        return v != null ? v.toString() : null;
    }

    public boolean getBoolean(String attr) {
        Object v = this.getObject(attr);
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return v.toString().trim().toLowerCase().equals("true");
        }
        if (v instanceof Integer) {
            return (Integer)v != 0;
        }
        if (v instanceof Long) {
            return (Long)v != 0L;
        }
        throw new ClassCastException("Invalid type value: " + v.getClass().getName());
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof DefaultEntity)) {
            return false;
        }
        return this.areEquals(this.data, ((DefaultEntity)o).data);
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuffer s = new StringBuffer();
        Enumeration keys = this.data.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            s.append(key + ": " + this.data.get(key) + "\n");
        }
        return s.toString();
    }

    public final int size() {
        return this.data.size();
    }

    public boolean isEmpty(String key) {
        Object v = this.data.get(key);
        return v == null || StringUtil.isEmpty(v.toString());
    }

    public boolean isNull(String key) {
        return this.data.get(key) == null;
    }

    public void checkEmpty(String key) {
        if (this.isEmpty(key)) {
            throw new IllegalArgumentException(key + " must not be empty.");
        }
    }

    private boolean areEquals(Hashtable h1, Hashtable h2) {
        if (h1.size() != h2.size()) {
            return false;
        }
        Enumeration keys = h1.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object val1 = h1.get(key);
            Object val2 = h2.get(key);
            if (val1 instanceof Object[] && val2 instanceof Object[]) {
                Object[] aval1 = (Object[])val1;
                Object[] aval2 = (Object[])val2;
                if (aval1.length != aval2.length) {
                    return false;
                }
                for (int i = 0; i < aval1.length; ++i) {
                    if (aval1[i].equals(aval2[i])) continue;
                    return false;
                }
                continue;
            }
            if (h1.get(key).equals(h2.get(key))) continue;
            return false;
        }
        return true;
    }

    private Object getValue(String attr, Class type) {
        Object v = this.data.get(attr);
        if (v != null && !type.isInstance(v)) {
            throw new ClassCastException("Invalid type value: " + v.getClass().getName());
        }
        return v;
    }
}

