/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class HumanReadable {
    private static final int ONE_KILOBYTE = 1024;
    private static final int ONE_MEGABYTE = 0x100000;
    private static final int ONE_GIGABYTE = 0x40000000;

    public static String getHumanReadableByteSize(long size) {
        double displaySize = size;
        DecimalFormat df = new DecimalFormat("#.#");
        DecimalFormatSymbols decimalFormatSymbols = df.getDecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(decimalFormatSymbols);
        String sizeSuffix = "B";
        if (displaySize >= 1.073741824E9) {
            displaySize /= 1.073741824E9;
            sizeSuffix = "GB";
        } else if (displaySize >= 1048576.0) {
            displaySize /= 1048576.0;
            sizeSuffix = "MB";
        } else if (displaySize >= 1024.0) {
            displaySize /= 1024.0;
            sizeSuffix = "kB";
        }
        return df.format(displaySize) + " " + sizeSuffix;
    }

    public static String getHumanReadableTimeSpan(long milliseconds) {
        long ms = milliseconds;
        TimeLengthSuffixPair[] pairs = new TimeLengthSuffixPair[]{new TimeLengthSuffixPair(3600000L, "h"), new TimeLengthSuffixPair(60000L, "m"), new TimeLengthSuffixPair(1000L, "s"), new TimeLengthSuffixPair(1L, "ms")};
        ArrayList<String> resultList = new ArrayList<String>();
        for (int i = 0; i < pairs.length; ++i) {
            TimeLengthSuffixPair pair = pairs[i];
            long timeLength = pair.timeLength;
            if (ms < timeLength) continue;
            long unitTime = ms / timeLength;
            ms %= timeLength;
            resultList.add(unitTime + pair.suffix);
        }
        return StringUtils.join(resultList.iterator(), (String)", ");
    }

    private static class TimeLengthSuffixPair {
        long timeLength;
        String suffix;

        TimeLengthSuffixPair(long timeLength, String suffix) {
            this.timeLength = timeLength;
            this.suffix = suffix;
        }
    }
}

