/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.oro.text.perl.Perl5Util;

public class MultipartHttpServletRequest
extends HttpServletRequestWrapper {
    private static final String CHARSET_ISO_8859_1 = "ISO-8859-1";
    private MultiMap fileItemMap;

    public MultipartHttpServletRequest(HttpServletRequest request) throws IOException {
        this(request, -1L);
    }

    public MultipartHttpServletRequest(HttpServletRequest request, long sizeLimit) throws IOException {
        super(request);
        if (FileUploadBase.isMultipartContent((HttpServletRequest)request)) {
            List fileItems;
            FileUpload fileUpload = new FileUpload((FileItemFactory)new DefaultFileItemFactory());
            fileUpload.setSizeMax(sizeLimit);
            try {
                fileItems = fileUpload.parseRequest(request);
            }
            catch (FileUploadException e) {
                throw new IOException(e.getMessage());
            }
            this.fileItemMap = new MultiHashMap();
            Iterator iterator = fileItems.iterator();
            while (iterator.hasNext()) {
                BaseNameFileItem fileItem = new BaseNameFileItem((FileItem)iterator.next());
                this.fileItemMap.put((Object)fileItem.getFieldName(), (Object)fileItem);
            }
        }
    }

    public String getParameter(String key) {
        String[] parameterValues = this.getParameterValues(key);
        if (null != parameterValues && parameterValues.length > 0) {
            return parameterValues[0];
        }
        return null;
    }

    public DataSourceFileItem getParameterFileItem(String key) {
        DataSourceFileItem[] parameterValues = this.getParameterFileItems(key);
        if (null != parameterValues && parameterValues.length > 0) {
            return parameterValues[0];
        }
        return null;
    }

    public DataSourceFileItem[] getParameterFileItems(String key) {
        if (null == this.fileItemMap) {
            return null;
        }
        Collection parameterFileItems = (Collection)this.fileItemMap.get((Object)key);
        if (null == parameterFileItems) {
            return null;
        }
        return parameterFileItems.toArray(new DataSourceFileItem[parameterFileItems.size()]);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = super.getParameterMap();
        if (null != this.fileItemMap) {
            map = new HashMap<String, String[]>(map);
            Set fileItemKeys = this.fileItemMap.keySet();
            Iterator iterator = fileItemKeys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, this.getParameterValues(key));
            }
        }
        return map;
    }

    public Enumeration getParameterNames() {
        Enumeration superParameterNames = super.getParameterNames();
        HashSet parameterNames = new HashSet();
        while (superParameterNames.hasMoreElements()) {
            parameterNames.add(superParameterNames.nextElement());
        }
        if (null != this.fileItemMap) {
            parameterNames.addAll(this.fileItemMap.keySet());
        }
        return new IteratorEnumeration(parameterNames.iterator());
    }

    public String[] getParameterValues(String key) {
        if (null != this.fileItemMap) {
            ArrayList<String> parameterValues = new ArrayList<String>();
            Collection fileItems = (Collection)this.fileItemMap.get((Object)key);
            if (null == fileItems) {
                return null;
            }
            Iterator iterator = fileItems.iterator();
            while (iterator.hasNext()) {
                FileItem fileItem = (FileItem)iterator.next();
                String contentType = fileItem.getContentType();
                parameterValues.add(this.getStringFromBytesWithContentType(fileItem.get(), contentType));
            }
            return parameterValues.toArray(new String[parameterValues.size()]);
        }
        return super.getParameterValues(key);
    }

    private String getStringFromBytesWithContentType(byte[] bytes, String contentType) {
        String charset = CHARSET_ISO_8859_1;
        if (null != contentType) {
            Perl5Util perl5Util = new Perl5Util();
            perl5Util.match("charset=\"?(\\S+?)\"?", contentType);
            String contentTypeCharset = perl5Util.group(1);
            try {
                return new String(bytes, contentTypeCharset);
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
        }
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException never) {
            return null;
        }
    }

    private class FileItemWrapper
    implements DataSourceFileItem {
        FileItem fileItem;

        private FileItemWrapper(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public String getFieldName() {
            return this.fileItem.getFieldName();
        }

        public void setFieldName(String s) {
            this.fileItem.setFieldName(s);
        }

        public InputStream getInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }

        public String getName() {
            return this.fileItem.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            return this.fileItem.getOutputStream();
        }

        public long getSize() {
            return this.fileItem.getSize();
        }

        public String getString() {
            return this.fileItem.getString();
        }

        public boolean isFormField() {
            return this.fileItem.isFormField();
        }

        public void setFormField(boolean b) {
            this.fileItem.setFormField(b);
        }

        public boolean isInMemory() {
            return this.fileItem.isInMemory();
        }

        public byte[] get() {
            return this.fileItem.get();
        }

        public void delete() {
            this.fileItem.delete();
        }

        public String getString(String s) throws UnsupportedEncodingException {
            return this.fileItem.getString(s);
        }

        public void write(File file) throws Exception {
            this.fileItem.write(file);
        }
    }

    private class BaseNameFileItem
    extends FileItemWrapper {
        private BaseNameFileItem(FileItem fileItem) {
            super(fileItem);
        }

        public String getName() {
            String filename = this.fileItem.getName();
            if (null != filename) {
                filename = filename.substring(filename.lastIndexOf(47) + 1);
                filename = filename.substring(filename.lastIndexOf(92) + 1);
            }
            return filename;
        }
    }

    public static interface DataSourceFileItem
    extends FileItem,
    DataSource {
    }
}

