/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.sql;

import com.imcode.forum.ForumPost;
import com.imcode.forum.ForumThread;
import com.imcode.forum.Id;
import com.imcode.forum.sql.SqlPostsSet;
import com.imcode.forum.sql.SqlRepository;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlThread
implements ForumThread {
    private final Id id;
    private SqlRepository sqlRepository;
    private SqlPostsSet postsSet;

    SqlThread(Id id, SqlRepository sqlRepository) {
        this.id = id;
        this.sqlRepository = sqlRepository;
    }

    @Override
    public ForumPost getTopPost() {
        return this.getSqlPosts().getTopPost();
    }

    @Override
    public ForumPost getNewestPost() {
        return this.getSqlPosts().getNewestPost();
    }

    @Override
    public Id getId() {
        return this.id;
    }

    private SqlPostsSet getSqlPosts() {
        if (null == this.postsSet) {
            this.postsSet = this.sqlRepository.getThreadPosts(this);
        }
        return this.postsSet;
    }

    @Override
    public ForumPost getPost(Id postId) {
        return this.getSqlPosts().getPost(postId);
    }

    @Override
    public int getPostCount() {
        return this.getSqlPosts().size();
    }

    public String toString() {
        return "thread " + this.id + " with " + this.getSqlPosts().size() + " posts, top " + this.getTopPost() + ", and newest " + this.getNewestPost();
    }

    Id createPostReply(Id postId, ForumPost forumPost) {
        Id replyId = this.sqlRepository.createPostReply(this.id, postId, forumPost);
        this.postsSet = null;
        return replyId;
    }

    SortedSet<ForumPost> getPostReplies(ForumPost post) {
        return this.getSqlPosts().getPostReplies(post.getId());
    }

    void incrementPostViewCount(Id postId) {
        this.sqlRepository.incrementPostViewCount(postId);
    }

    void hidePost(Id postId, boolean hidden) {
        this.sqlRepository.hidePost(this.id, postId, hidden);
    }
}

