/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.sql;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.DatasourceDatabase;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryDatabaseCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import com.imcode.db.commands.UpdateTableWhereColumnEqualsDatabaseCommand;
import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.handlers.ObjectFromFirstRowResultSetHandler;
import com.imcode.db.handlers.ObjectFromRowFactory;
import com.imcode.forum.Forum;
import com.imcode.forum.ForumPost;
import com.imcode.forum.ForumRepository;
import com.imcode.forum.ForumThread;
import com.imcode.forum.Id;
import com.imcode.forum.sql.CollectionResultSetHandler;
import com.imcode.forum.sql.ForumDdl;
import com.imcode.forum.sql.MssqlForumDdl;
import com.imcode.forum.sql.MysqlForumDdl;
import com.imcode.forum.sql.SqlForum;
import com.imcode.forum.sql.SqlForumFactory;
import com.imcode.forum.sql.SqlId;
import com.imcode.forum.sql.SqlPostFactory;
import com.imcode.forum.sql.SqlPostsSet;
import com.imcode.forum.sql.SqlThread;
import com.imcode.forum.sql.SqlThreadFactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRepository
implements ForumRepository {
    private static final String SQL_STATE__MISSING_TABLE = "42S02";
    private Database database;
    private static final String TABLE_POSTS = "forum_posts";
    private static final String TABLE_THREADS = "forum_threads";
    private static final String TABLE_FORUMS = "forum_forums";

    public String toString() {
        return ClassUtils.getShortClassName(this.getClass()) + "(" + this.database + ")";
    }

    public SqlRepository(Database database) {
        this.database = database;
    }

    public SqlRepository(DataSource dataSource) {
        this((Database)new DatasourceDatabase(dataSource));
    }

    public void dropTables() {
        this.database.executeCommand(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection connection) throws DatabaseException {
                try {
                    Set tableNames = SqlRepository.this.getTableNames(connection, "forum_%");
                    this.dropTable(connection, SqlRepository.TABLE_POSTS, tableNames);
                    this.dropTable(connection, SqlRepository.TABLE_THREADS, tableNames);
                    this.dropTable(connection, SqlRepository.TABLE_FORUMS, tableNames);
                    return null;
                }
                catch (SQLException e) {
                    throw DatabaseException.fromSQLException(null, (SQLException)e);
                }
            }

            private void dropTable(DatabaseConnection connection, String tableName, Set<String> tableNames) {
                if (tableNames.contains(tableName)) {
                    connection.executeUpdate("DROP TABLE " + tableName, null);
                }
            }
        });
    }

    public void createTables() {
        final String databaseProductName = this.getDatabaseProductName();
        this.database.executeCommand(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection connection) throws DatabaseException {
                try {
                    ForumDdl forumDdl = null;
                    if ("mysql".equalsIgnoreCase(databaseProductName)) {
                        forumDdl = new MysqlForumDdl();
                    } else if ("microsoft sql server".equalsIgnoreCase(databaseProductName)) {
                        forumDdl = new MssqlForumDdl();
                    } else {
                        throw new DatabaseException("Unsupported database: " + databaseProductName, null);
                    }
                    Set tableNames = SqlRepository.this.getTableNames(connection, "forum_%");
                    SqlRepository.this.createTable(connection, SqlRepository.TABLE_FORUMS, forumDdl.getForumsDdl(), tableNames);
                    SqlRepository.this.createTable(connection, SqlRepository.TABLE_THREADS, forumDdl.getThreadsDdl(), tableNames);
                    SqlRepository.this.createTable(connection, SqlRepository.TABLE_POSTS, forumDdl.getPostsDdl(), tableNames);
                }
                catch (SQLException e) {
                    throw DatabaseException.fromSQLException(null, (SQLException)e);
                }
                return null;
            }
        });
    }

    private String getDatabaseProductName() {
        return (String)this.database.executeCommand(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection connection) throws DatabaseException {
                try {
                    DatabaseMetaData metaData = connection.getConnection().getMetaData();
                    return metaData.getDatabaseProductName();
                }
                catch (SQLException e) {
                    throw DatabaseException.fromSQLException(null, (SQLException)e);
                }
            }
        });
    }

    private void createTable(DatabaseConnection connection, String tableName, String tableDdl, Set<String> tableNames) {
        if (!tableNames.contains(tableName)) {
            connection.executeUpdate(tableDdl, null);
        }
    }

    private Set<String> getTableNames(DatabaseConnection connection, String tableNamePattern) throws SQLException {
        DatabaseMetaData metaData = connection.getConnection().getMetaData();
        ResultSet tablesResultSet = metaData.getTables(null, null, tableNamePattern, null);
        HashSet<String> tableNames = new HashSet<String>();
        while (tablesResultSet.next()) {
            String tableName = tablesResultSet.getString("TABLE_NAME");
            tableNames.add(tableName);
        }
        return tableNames;
    }

    @Override
    public Forum getForum(Id id) {
        try {
            return this.tryGetForum(id);
        }
        catch (DatabaseException dbe) {
            for (Throwable t = dbe; null != t; t = t.getCause()) {
                if (!(t instanceof SQLException) || !SQL_STATE__MISSING_TABLE.equals(((SQLException)t).getSQLState())) continue;
                this.createTables();
                return this.tryGetForum(id);
            }
            throw dbe;
        }
    }

    private Forum tryGetForum(Id id) {
        return (Forum)this.database.executeCommand((DatabaseCommand)new SqlQueryDatabaseCommand("SELECT forum_id from forum_forums WHERE forum_id = ?", new Object[]{id.getValue()}, (ResultSetHandler)new ObjectFromFirstRowResultSetHandler((ObjectFromRowFactory)new SqlForumFactory(this))));
    }

    ForumThread createThread(final Id forumId, final ForumPost post) {
        Id threadId = (Id)this.database.executeCommand((DatabaseCommand)new TransactionDatabaseCommand(){

            public Object executeInTransaction(DatabaseConnection connection) throws DatabaseException {
                SqlId threadId = new SqlId((Number)new InsertIntoTableDatabaseCommand(SqlRepository.TABLE_THREADS, (Object[][])new Object[][]{{"forum_id", forumId.getValue()}}).executeOn(connection));
                SqlRepository.this.createPost(connection, threadId, null, post);
                return threadId;
            }
        });
        return new SqlThread(threadId, this);
    }

    List<ForumThread> getForumThreads(Id forumId) {
        return (List)this.database.executeCommand((DatabaseCommand)new SqlQueryDatabaseCommand("SELECT ft.thread_id\nFROM forum_threads ft\nJOIN (SELECT thread_id, MAX(datetime) datetime FROM forum_posts GROUP BY thread_id) np\nON ft.thread_id = np.thread_id\nWHERE ft.forum_id = ?\nORDER BY np.datetime DESC\n", new Object[]{forumId.getValue()}, (ResultSetHandler)new CollectionResultSetHandler(new SqlThreadFactory(this), new ArrayList())));
    }

    @Override
    public List<Forum> getForums() {
        try {
            return this.tryGetForums();
        }
        catch (DatabaseException dbe) {
            for (Throwable t = dbe; null != t; t = t.getCause()) {
                if (!(t instanceof SQLException) || !SQL_STATE__MISSING_TABLE.equals(((SQLException)t).getSQLState())) continue;
                this.createTables();
                return this.tryGetForums();
            }
            throw dbe;
        }
    }

    private List<Forum> tryGetForums() {
        return (List)this.database.executeCommand((DatabaseCommand)new SqlQueryDatabaseCommand("SELECT forum_id FROM forum_forums", null, (ResultSetHandler)new CollectionResultSetHandler(new SqlForumFactory(this), new ArrayList())));
    }

    @Override
    public Forum createForum(Id forumId) {
        try {
            this.tryCreateForum(forumId);
        }
        catch (DatabaseException dbe) {
            for (Throwable t = dbe; null != t; t = t.getCause()) {
                if (t instanceof IntegrityConstraintViolationException) {
                    return this.getForum(forumId);
                }
                if (!(t instanceof SQLException) || !SQL_STATE__MISSING_TABLE.equals(((SQLException)t).getSQLState())) continue;
                this.createTables();
                this.tryCreateForum(forumId);
                return new SqlForum(this, forumId);
            }
            throw dbe;
        }
        return new SqlForum(this, forumId);
    }

    private void tryCreateForum(Id forumId) {
        this.database.executeCommand((DatabaseCommand)new InsertIntoTableDatabaseCommand(TABLE_FORUMS, (Object[][])new Object[][]{{"forum_id", forumId.getValue()}}));
    }

    @Override
    public Id createId(Object value) {
        if (value instanceof String) {
            return new SqlId(Long.valueOf((String)value));
        }
        return new SqlId((Number)value);
    }

    ForumThread getThread(Id threadId) {
        return (ForumThread)this.database.executeCommand((DatabaseCommand)new SqlQueryDatabaseCommand("SELECT forum_threads.thread_id FROM forum_threads WHERE forum_threads.thread_id = ?", new Object[]{threadId.getValue()}, (ResultSetHandler)new ObjectFromFirstRowResultSetHandler((ObjectFromRowFactory)new SqlThreadFactory(this))));
    }

    private Id createPost(DatabaseConnection connection, Id threadId, Id parentPostId, ForumPost post) {
        return new SqlId((Number)new InsertIntoTableDatabaseCommand(TABLE_POSTS, (Object[][])new Object[][]{{"thread_id", threadId.getValue()}, {"parent_post_id", null == parentPostId ? null : parentPostId.getValue()}, {"datetime", new Timestamp(post.getDateTime().getTime())}, {"userdata", post.getUser()}, {"title", post.getTitle()}, {"body", post.getBody()}, {"hidden", new Boolean(post.isHidden())}}).executeOn(connection));
    }

    void incrementPostViewCount(Id postId) {
        this.database.executeCommand((DatabaseCommand)new SqlUpdateDatabaseCommand("UPDATE forum_posts SET view_count = view_count + 1 WHERE post_id = ?", new Object[]{postId.getValue()}));
    }

    Id createPostReply(final Id threadId, final Id postId, final ForumPost forumPost) {
        return (Id)this.database.executeCommand(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection connection) throws DatabaseException {
                return SqlRepository.this.createPost(connection, threadId, postId, forumPost);
            }
        });
    }

    SqlPostsSet getThreadPosts(SqlThread thread) {
        return (SqlPostsSet)this.database.executeCommand((DatabaseCommand)new SqlQueryDatabaseCommand("SELECT forum_posts.post_id, forum_posts.parent_post_id, forum_posts.title, forum_posts.body, forum_posts.datetime, forum_posts.view_count, forum_posts.userdata, forum_posts.hidden FROM forum_posts WHERE thread_id = ? ORDER BY datetime, post_id", new Object[]{thread.getId().getValue()}, (ResultSetHandler)new CollectionResultSetHandler(new SqlPostFactory(thread), new SqlPostsSet())));
    }

    void hidePost(Id sqlThread, Id post, boolean hidden) {
        this.database.executeCommand((DatabaseCommand)new UpdateTableWhereColumnEqualsDatabaseCommand(TABLE_POSTS, "post_id", post.getValue(), (Object[][])new Object[][]{{"hidden", new Boolean(hidden)}}));
    }
}

