/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.sql;

import com.imcode.forum.ForumPost;
import com.imcode.forum.Id;
import com.imcode.forum.SimpleForumPost;
import com.imcode.forum.sql.SqlPost;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlPostsSet
extends AbstractSet<ForumPost> {
    private SqlPost newestPost;
    private SqlPost topPost;
    private Map<Id, SortedSet<ForumPost>> parentPostIdToRepliesMap = new HashMap<Id, SortedSet<ForumPost>>();
    private Map<Id, ForumPost> posts = new HashMap<Id, ForumPost>();

    SqlPostsSet() {
    }

    @Override
    public boolean add(ForumPost fp) {
        Id parentPostId;
        SqlPost post = (SqlPost)fp;
        if (null == this.newestPost || post.getDateTime().after(this.newestPost.getDateTime())) {
            this.newestPost = post;
        }
        if (null == (parentPostId = post.getParentPostId())) {
            this.topPost = post;
        } else {
            SortedSet<ForumPost> repliesSet = this.getRepliesToPostWithId(parentPostId);
            repliesSet.add(post);
        }
        return null == this.posts.put(post.getId(), post);
    }

    private SortedSet<ForumPost> getRepliesToPostWithId(Id parentPostId) {
        SortedSet<ForumPost> repliesSet = this.parentPostIdToRepliesMap.get(parentPostId);
        if (null == repliesSet) {
            repliesSet = new TreeSet<ForumPost>(SimpleForumPost.DATETIME_COMPARATOR);
            this.parentPostIdToRepliesMap.put(parentPostId, repliesSet);
        }
        return repliesSet;
    }

    ForumPost getNewestPost() {
        return this.newestPost;
    }

    ForumPost getTopPost() {
        return this.topPost;
    }

    SortedSet<ForumPost> getPostReplies(Id postId) {
        return this.getRepliesToPostWithId(postId);
    }

    ForumPost getPost(Id postId) {
        return this.posts.get(postId);
    }

    @Override
    public Iterator<ForumPost> iterator() {
        return this.posts.values().iterator();
    }

    @Override
    public int size() {
        return this.posts.size();
    }
}

