/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.shell;

import com.imcode.forum.Forum;
import com.imcode.forum.ForumRepository;
import com.imcode.forum.ForumThread;
import com.imcode.forum.Id;
import com.imcode.forum.shell.ForumShellCommand;
import java.io.PrintStream;
import java.util.List;

class ListThreadsCommand
implements ForumShellCommand {
    ListThreadsCommand() {
    }

    public void execute(ForumRepository repository, PrintStream out, String[] commandParameters) {
        Id id = repository.createId(Integer.parseInt(commandParameters[0]));
        Forum forum = repository.getForum(id);
        if (null == forum) {
            out.println("No forum with id " + id);
            return;
        }
        List<ForumThread> threads = forum.getThreads();
        for (ForumThread forumThread : threads) {
            out.println(forumThread);
        }
    }

    public String[] getParameterNames() {
        return new String[]{"forum-id"};
    }

    public String getPurpose() {
        return "List threads";
    }
}

