/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.shell;

import com.imcode.forum.Forum;
import com.imcode.forum.ForumPost;
import com.imcode.forum.ForumRepository;
import com.imcode.forum.ForumThread;
import com.imcode.forum.shell.ForumShellCommand;
import java.io.PrintStream;
import java.util.Iterator;

public class ListPostsCommand
implements ForumShellCommand {
    public void execute(ForumRepository repository, PrintStream out, String[] commandParameters) {
        int forumId = Integer.parseInt(commandParameters[0]);
        int threadId = Integer.parseInt(commandParameters[1]);
        Forum forum = repository.getForum(repository.createId(forumId));
        ForumThread thread = forum.getThread(repository.createId(threadId));
        ForumPost post = thread.getTopPost();
        String indent = "";
        this.printPostTree(indent, post, out);
    }

    private void printPostTree(String indent, ForumPost post, PrintStream out) {
        out.println(indent + post);
        Iterator iterator = post.getReplies().iterator();
        while (iterator.hasNext()) {
            this.printPostTree(indent + "  ", (ForumPost)iterator.next(), out);
        }
    }

    public String[] getParameterNames() {
        return new String[]{"forum-id", "thread-id"};
    }

    public String getPurpose() {
        return "List posts";
    }
}

