/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.shell;

import com.imcode.forum.ForumRepository;
import com.imcode.forum.shell.CreateForumCommand;
import com.imcode.forum.shell.CreatePostCommand;
import com.imcode.forum.shell.CreateThreadCommand;
import com.imcode.forum.shell.ForumShellCommand;
import com.imcode.forum.shell.ListForumsCommand;
import com.imcode.forum.shell.ListPostsCommand;
import com.imcode.forum.shell.ListThreadsCommand;
import com.imcode.forum.shell.QuitCommand;
import com.imcode.forum.sql.SqlRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class ForumShell {
    private ForumRepository repository;
    private PrintStream out;
    private BufferedReader in;
    private Map commandMap = ArrayUtils.toMap((Object[])new Object[][]{{"q", new QuitCommand()}, {"lf", new ListForumsCommand()}, {"lt", new ListThreadsCommand()}, {"lp", new ListPostsCommand()}, {"cf", new CreateForumCommand()}, {"ct", new CreateThreadCommand()}, {"cp", new CreatePostCommand()}});

    private ForumShell(ForumRepository repository, PrintStream out) {
        this.repository = repository;
        this.out = out;
        this.in = new BufferedReader(new InputStreamReader(System.in));
    }

    private static BasicDataSource createDataSource(String[] args) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(args[0]);
        dataSource.setUrl(args[1]);
        dataSource.setUsername(args[2]);
        dataSource.setPassword(args[3]);
        return dataSource;
    }

    public static void main(String[] args) {
        BasicDataSource dataSource = ForumShell.createDataSource(args);
        SqlRepository repository = new SqlRepository((DataSource)dataSource);
        ForumShell forumShell = new ForumShell(repository, System.out);
        forumShell.run();
    }

    private String prompt(String prompt) {
        this.out.print(prompt + "> ");
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private String prompt() {
        return this.prompt("");
    }

    private void run() {
        while (true) {
            this.parseCommand(this.prompt());
        }
    }

    private void parseCommand(String inputString) {
        Pattern commandPattern = Pattern.compile("^(\\w+) *");
        Matcher matcher = commandPattern.matcher(inputString);
        if (!matcher.find()) {
            this.printAvailableCommands();
            return;
        }
        String command = matcher.group(1);
        String commandParameters = matcher.replaceFirst("");
        String[] splitCommandParameters = commandParameters.split(" +");
        if (0 == splitCommandParameters[0].length()) {
            splitCommandParameters = new String[]{};
        }
        this.handleCommand(command, splitCommandParameters);
    }

    private void handleCommand(String commandName, String[] commandParameters) {
        ForumShellCommand command = (ForumShellCommand)this.commandMap.get(commandName);
        if (null == command) {
            this.printAvailableCommands();
            return;
        }
        String[] parameterNames = command.getParameterNames();
        if (commandParameters.length != parameterNames.length) {
            this.printCommandSyntax(commandName, command);
            return;
        }
        try {
            command.execute(this.repository, this.out, commandParameters);
        }
        catch (NumberFormatException nfe) {
            this.printCommandSyntax(commandName, command);
        }
    }

    private void printCommandSyntax(String commandName, ForumShellCommand command) {
        this.out.println(commandName + ": " + command.getPurpose() + ".");
        this.out.println("Syntax: " + this.getCommandSyntax(commandName, command));
    }

    private void printAvailableCommands() {
        this.out.println("Available commands are:");
        TreeSet commandNames = new TreeSet(this.commandMap.keySet());
        for (String commandName : commandNames) {
            ForumShellCommand command = (ForumShellCommand)this.commandMap.get(commandName);
            this.out.println(StringUtils.rightPad((String)(command.getPurpose() + ":"), (int)15) + " " + this.getCommandSyntax(commandName, command));
        }
    }

    private String getCommandSyntax(String commandName, ForumShellCommand command) {
        Object[] parameterNames = command.getParameterNames();
        for (int i = 0; i < parameterNames.length; ++i) {
            parameterNames[i] = "<" + parameterNames[i] + ">";
        }
        String commandSyntax = commandName + " " + StringUtils.join((Object[])parameterNames, (String)" ");
        return commandSyntax;
    }
}

