/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.sql;

import com.imcode.db.handlers.ObjectFromRowFactory;
import com.imcode.forum.sql.SqlId;
import com.imcode.forum.sql.SqlPost;
import com.imcode.forum.sql.SqlThread;
import java.sql.ResultSet;
import java.sql.SQLException;

class SqlPostFactory
implements ObjectFromRowFactory {
    static final String POST_COLUMNS = "forum_posts.post_id, forum_posts.parent_post_id, forum_posts.title, forum_posts.body, forum_posts.datetime, forum_posts.view_count, forum_posts.userdata, forum_posts.hidden";
    private SqlThread thread;

    SqlPostFactory(SqlThread thread) {
        this.thread = thread;
    }

    public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
        SqlId postId = new SqlId((Number)resultSet.getObject("post_id"));
        SqlPost forumPost = new SqlPost(postId, this.thread);
        forumPost.setParentPostId(this.nullOrId((Number)resultSet.getObject("parent_post_id")));
        forumPost.setTitle(resultSet.getString("title"));
        forumPost.setBody(resultSet.getString("body"));
        forumPost.setDateTime(resultSet.getTimestamp("datetime"));
        forumPost.setViewCount(resultSet.getInt("view_count"));
        forumPost.setUser(resultSet.getString("userdata"));
        forumPost.setHidden(resultSet.getBoolean("hidden"));
        return forumPost;
    }

    private SqlId nullOrId(Number o) {
        return null == o ? null : new SqlId(o);
    }

    public Class getClassOfCreatedObjects() {
        return SqlPost.class;
    }
}

