/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum.sql;

import com.imcode.forum.ForumPost;
import com.imcode.forum.Id;
import com.imcode.forum.sql.SqlId;
import com.imcode.forum.sql.SqlThread;
import java.util.Date;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlPost
implements ForumPost {
    private String title;
    private String user;
    private Date dateTime = new Date();
    private String body;
    private int viewCount;
    private SqlThread thread;
    private final Id id;
    private Id parentPostId;
    private boolean hidden;

    SqlPost(Id id, SqlThread thread) {
        this.id = id;
        this.thread = thread;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Date getDateTime() {
        return (Date)this.dateTime.clone();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void hide(boolean hidden) {
        this.thread.hidePost(this.id, hidden);
        this.setHidden(hidden);
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public SortedSet<ForumPost> getReplies() {
        return this.thread.getPostReplies(this);
    }

    @Override
    public void incrementViewCount() {
        this.thread.incrementPostViewCount(this.id);
        ++this.viewCount;
    }

    public String toString() {
        return "post " + this.id + " '" + this.title + "' created at " + this.dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = (Date)dateTime.clone();
    }

    public void setViewCount(int viewCount) {
        this.viewCount = viewCount;
    }

    @Override
    public int getViewCount() {
        return this.viewCount;
    }

    @Override
    public Id createReply(ForumPost forumPost) {
        return this.thread.createPostReply(this.id, forumPost);
    }

    @Override
    public Id getId() {
        return this.id;
    }

    public Id getParentPostId() {
        return this.parentPostId;
    }

    public void setParentPostId(SqlId parentPostId) {
        this.parentPostId = parentPostId;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

