/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.forum;

import com.imcode.forum.ForumPost;
import com.imcode.forum.Id;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.NullArgumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleForumPost
implements ForumPost {
    public static final Comparator<ForumPost> DATETIME_COMPARATOR = new Comparator<ForumPost>(){

        @Override
        public int compare(ForumPost o1, ForumPost o2) {
            return o1.getDateTime().compareTo(o2.getDateTime());
        }
    };
    private String title = "";
    private String body = "";
    private String user = "";
    private Date dateTime = new Date();
    private int viewCount;
    private SortedSet<ForumPost> replies = new TreeSet<ForumPost>(DATETIME_COMPARATOR);
    private boolean hidden;

    public SimpleForumPost() {
    }

    public SimpleForumPost(String title, String body, String user) {
        this.setTitle(title);
        this.setBody(body);
        this.setUser(user);
    }

    @Override
    public int getViewCount() {
        return this.viewCount;
    }

    @Override
    public Id createReply(ForumPost forumPost) {
        this.replies.add(forumPost);
        return forumPost.getId();
    }

    private void setTitle(String title) {
        if (null == title) {
            throw new NullArgumentException("title");
        }
        this.title = title;
    }

    private void setBody(String body) {
        if (null == body) {
            throw new NullArgumentException("body");
        }
        this.body = body;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setDateTime(Date dateTime) {
        if (null == dateTime) {
            throw new NullArgumentException("dateTime");
        }
        this.dateTime = (Date)dateTime.clone();
    }

    @Override
    public Id getId() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Date getDateTime() {
        return (Date)this.dateTime.clone();
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void hide(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public SortedSet<ForumPost> getReplies() {
        return Collections.unmodifiableSortedSet(this.replies);
    }

    @Override
    public void incrementViewCount() {
        ++this.viewCount;
    }
}

