/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db.commands;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.ColumnValuesDatabaseCommand;
import org.apache.commons.lang.StringUtils;

public class UpdateTableWhereColumnEqualsDatabaseCommand
extends ColumnValuesDatabaseCommand {
    private final String columnName;
    private Object columnValue;

    public UpdateTableWhereColumnEqualsDatabaseCommand(String tableName, String columnName, Object columnValue, Object[][] columnNamesAndValues) {
        super(tableName, columnNamesAndValues);
        this.columnName = columnName;
        this.columnValue = columnValue;
    }

    public Object executeOn(DatabaseConnection connection) throws DatabaseException {
        Object[] columnNamePlaceHolderPairs = new String[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            columnNamePlaceHolderPairs[i] = this.columnNames[i] + " = ?";
        }
        Object[] parameters = new Object[this.columnValues.length + 1];
        System.arraycopy(this.columnValues, 0, parameters, 0, this.columnValues.length);
        parameters[parameters.length - 1] = this.columnValue;
        return new Integer(connection.executeUpdate("UPDATE " + this.tableName + " SET " + StringUtils.join((Object[])columnNamePlaceHolderPairs, (String)", ") + " WHERE " + this.columnName + " = ?", parameters));
    }
}

