/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db;

import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.JdbcUtils;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class JdbcDatabaseConnection
implements DatabaseConnection {
    private Connection connection;
    private QueryRunner queryRunner = new QueryRunner();

    public JdbcDatabaseConnection(Connection connection) {
        this.connection = connection;
    }

    public int executeUpdate(String sql, Object[] parameters) throws DatabaseException {
        try {
            return this.queryRunner.update(this.getConnection(), sql, parameters);
        }
        catch (SQLException se) {
            throw DatabaseException.fromSQLException(se);
        }
    }

    public Number executeUpdateAndGetGeneratedKey(String sql, Object[] parameters) throws DatabaseException {
        try {
            return JdbcUtils.executeUpdateAndGetGeneratedKey(this.getConnection(), sql, parameters);
        }
        catch (SQLException se) {
            throw DatabaseException.fromSQLException(se);
        }
    }

    public Object executeQuery(String sqlQuery, Object[] parameters, ResultSetHandler resultSetHandler) throws DatabaseException {
        try {
            return this.queryRunner.query(this.getConnection(), sqlQuery, parameters, resultSetHandler);
        }
        catch (SQLException e) {
            throw DatabaseException.fromSQLException(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

