/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.db;

import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.exceptions.StringTruncationException;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class DatabaseException
extends RuntimeException {
    public DatabaseException(String message, Throwable ex) {
        super(message, ex);
    }

    public static DatabaseException fromSQLException(SQLException cause) {
        return DatabaseException.fromSQLException(null, cause);
    }

    public static DatabaseException fromSQLException(String message, SQLException cause) {
        DatabaseException result;
        String sqlState = cause.getSQLState();
        if (null == sqlState) {
            if (null == message) {
                message = cause.getMessage();
            }
            result = new DatabaseException(message, cause);
        } else if ("23000".equals(sqlState)) {
            result = new IntegrityConstraintViolationException(message, cause);
        } else if ("01004".equals(sqlState)) {
            result = new StringTruncationException(message, cause);
        } else {
            String newMessage = "SQLException with SQLState " + sqlState + (StringUtils.isBlank((String)message) ? "" : ": " + message);
            result = new DatabaseException(newMessage, cause);
        }
        return result;
    }
}

