/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.ant.tasks;

import com.imcode.util.LineReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.util.FileUtils;

public class Translate
extends Task {
    private File toDir;
    private String startToken;
    private String endToken;
    private File bundle;
    private String bundleLanguage;
    private List fileSets = new ArrayList();
    private int verbosity = 3;
    private boolean filtering;
    private List filterSets = new ArrayList();
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Properties bundleProperties = new Properties();
    private long bundleFileLastModified;
    private File bundleFile;

    public void addFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setBundle(File bundle) {
        this.bundle = bundle;
    }

    public void setBundleLanguage(String bundleLanguage) {
        this.bundleLanguage = bundleLanguage;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.add(filterSet);
        return filterSet;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void execute() {
        this.validateAttributes();
        this.loadBundle();
        FilterSetCollection filters = this.getFilterSetCollection();
        this.translateFiles(filters);
    }

    private void translateFiles(FilterSetCollection filters) {
        Iterator it = this.fileSets.iterator();
        while (it.hasNext()) {
            FileSet fileSet = (FileSet)it.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] sourceFiles = directoryScanner.getIncludedFiles();
            this.log("Translating " + sourceFiles.length + (sourceFiles.length == 1 ? " file to " : " files to ") + this.toDir, this.verbosity);
            for (int i = 0; i < sourceFiles.length; ++i) {
                boolean needsWork;
                String sourcePath = sourceFiles[i];
                File destFile = this.fileUtils.resolveFile(this.toDir, sourcePath);
                File destDir = destFile.getParentFile();
                if (!destDir.exists() && !destDir.mkdirs()) {
                    throw new BuildException("Failed to create directory " + destDir);
                }
                File sourceFile = this.fileUtils.resolveFile(directoryScanner.getBasedir(), sourcePath);
                long destFileLastModified = destFile.lastModified();
                boolean bl = needsWork = destFileLastModified < sourceFile.lastModified() || destFileLastModified < this.bundleFileLastModified;
                if (needsWork) {
                    this.log("Translating file " + sourceFile + " to file " + destFile, this.verbosity);
                    this.translateFile(sourceFile, destFile, filters);
                    continue;
                }
                this.log("Omitting translation of " + sourceFile + " as " + destFile + " is up-to-date.", this.verbosity);
            }
        }
    }

    private void translateFile(File sourceFile, File destFile, FilterSetCollection filters) {
        try {
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            FileOutputStream destStream = new FileOutputStream(destFile);
            this.translateStream(sourceStream, destStream, filters);
        }
        catch (IOException e) {
            destFile.delete();
            throw new BuildException((Throwable)e);
        }
        catch (PropertiesNotFoundException e) {
            destFile.delete();
            Object[] missingPropertyKeys = e.getPropertyKeys();
            String missingPropertyKeysString = StringUtils.join((Object[])missingPropertyKeys, (String)", ");
            String message = "\n" + sourceFile + ":0: " + (missingPropertyKeys.length > 1 ? "Keys " : "Key ") + missingPropertyKeysString + " not found in " + this.bundleFile;
            throw new BuildException(message);
        }
    }

    private void translateStream(InputStream sourceStream, FileOutputStream destStream, FilterSetCollection filters) throws IOException, PropertiesNotFoundException {
        String line;
        LineReader lineReader = new LineReader((Reader)new BufferedReader(new InputStreamReader(sourceStream)));
        BufferedWriter destWriter = new BufferedWriter(new OutputStreamWriter(destStream));
        ArrayList<String> propertiesNotFound = new ArrayList<String>();
        while (null != (line = lineReader.readLine())) {
            try {
                String translatedLine = this.translateLine(line);
                String translatedAndFilteredLine = filters.replaceTokens(translatedLine);
                destWriter.write(translatedAndFilteredLine);
            }
            catch (PropertiesNotFoundException e) {
                propertiesNotFound.addAll(Arrays.asList(e.getPropertyKeys()));
            }
        }
        destWriter.flush();
        destWriter.close();
        if (!propertiesNotFound.isEmpty()) {
            throw new PropertiesNotFoundException(propertiesNotFound.toArray(new String[propertiesNotFound.size()]));
        }
    }

    private String translateLine(String line) throws PropertiesNotFoundException {
        int endTokenIndex;
        String translatedLine = line;
        ArrayList<String> propertiesNotFound = new ArrayList<String>();
        int startTokenIndex = 0;
        while (-1 != (startTokenIndex = translatedLine.indexOf(this.startToken, startTokenIndex)) && -1 != (endTokenIndex = translatedLine.indexOf(this.endToken, startTokenIndex + this.startToken.length()))) {
            String bundleKey = translatedLine.substring(startTokenIndex + this.startToken.length(), endTokenIndex);
            String bundleValue = this.bundleProperties.getProperty(bundleKey);
            if (null == bundleValue) {
                bundleValue = bundleKey;
                propertiesNotFound.add(bundleKey);
            } else {
                this.log("Replacing key " + bundleKey + " with value " + bundleValue, 4);
                translatedLine = translatedLine.substring(0, startTokenIndex) + bundleValue + translatedLine.substring(endTokenIndex + this.endToken.length());
            }
            startTokenIndex += bundleValue.length();
        }
        if (!propertiesNotFound.isEmpty()) {
            throw new PropertiesNotFoundException(propertiesNotFound.toArray(new String[propertiesNotFound.size()]));
        }
        return translatedLine;
    }

    private void loadBundle() {
        this.bundleFile = new File(this.bundle.getPath() + '_' + this.bundleLanguage + ".properties");
        this.bundleFileLastModified = this.bundleFile.lastModified();
        try {
            this.bundleProperties.load(new FileInputStream(this.bundleFile));
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateAttributes() {
        if (this.fileSets.size() == 0) {
            throw new BuildException("Specify at least one fileset.");
        }
        if (null == this.toDir) {
            throw new BuildException("The todir attribute must be set.");
        }
        if (null == this.bundle) {
            throw new BuildException("The bundle attribute must be set.");
        }
        if (null == this.bundleLanguage) {
            this.bundleLanguage = Locale.getDefault().getLanguage();
        }
    }

    private FilterSetCollection getFilterSetCollection() {
        FilterSetCollection executionFilters = new FilterSetCollection();
        if (this.filtering) {
            executionFilters.addFilterSet(this.project.getGlobalFilterSet());
        }
        Iterator filterEnum = this.filterSets.iterator();
        while (filterEnum.hasNext()) {
            executionFilters.addFilterSet((FilterSet)filterEnum.next());
        }
        return executionFilters;
    }

    private static class PropertiesNotFoundException
    extends Exception {
        private String[] propertyKeys;

        public PropertiesNotFoundException(String[] propertyKeys) {
            this.propertyKeys = propertyKeys;
        }

        public String[] getPropertyKeys() {
            return this.propertyKeys;
        }
    }
}

