/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.ant.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ChecksumFiles
extends Task {
    private List fileSets = new ArrayList();
    private File destFile;
    private boolean append = false;
    private String digest;

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void execute() {
        this.validateAttributes();
        BufferedWriter fileWriter = this.openDestFile(this.destFile);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Iterator iterator = this.fileSets.iterator();
        while (iterator.hasNext()) {
            FileSet fileSet = (FileSet)iterator.next();
            this.outputDataAboutFileSet(fileSet, fileWriter, dateFormat);
        }
        this.closeDestFile(fileWriter);
    }

    private void closeDestFile(BufferedWriter fileWriter) {
        try {
            fileWriter.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private BufferedWriter openDestFile(File destFile) {
        try {
            return new BufferedWriter(new FileWriter(destFile, this.append));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void outputDataAboutFileSet(FileSet fileSet, BufferedWriter destWriter, DateFormat dateFormat) {
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(fileSet.getProject());
        File baseDir = directoryScanner.getBasedir();
        String[] includedRelativeFilenames = directoryScanner.getIncludedFiles();
        this.outputDataAboutFilesRelativeToBaseDir(baseDir, includedRelativeFilenames, dateFormat, destWriter);
    }

    private void outputDataAboutFilesRelativeToBaseDir(File baseDir, String[] relativeFilenames, DateFormat dateFormat, BufferedWriter destWriter) {
        for (int i = 0; i < relativeFilenames.length; ++i) {
            String relativeFilename = relativeFilenames[i];
            this.outputDataAboutFileRelativeToBaseDir(baseDir, relativeFilename, dateFormat, destWriter);
        }
    }

    private void outputDataAboutFileRelativeToBaseDir(File baseDir, String relativeFilename, DateFormat dateFormat, BufferedWriter destWriter) {
        File file = new File(baseDir, relativeFilename);
        String digestString = this.digestFile(file);
        digestString = StringUtils.leftPad((String)digestString, (int)32);
        String fileLength = "" + file.length();
        fileLength = StringUtils.leftPad((String)fileLength, (int)8);
        String datetime = dateFormat.format(new Date(file.lastModified()));
        try {
            destWriter.write(datetime + " " + fileLength + " " + digestString + " " + relativeFilename);
            destWriter.newLine();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String digestFile(File includedFile) {
        MessageDigest messageDigest = this.getMessageDigest();
        FileInputStream inputStream = this.openFile(includedFile);
        try {
            byte[] buffer = new byte[16384];
            int bytesRead = 0;
            while (-1 != (bytesRead = inputStream.read(buffer))) {
                messageDigest.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        byte[] digestBytes = messageDigest.digest();
        BigInteger digestInteger = new BigInteger(1, digestBytes);
        return digestInteger.toString(16);
    }

    private FileInputStream openFile(File includedFile) {
        try {
            return new FileInputStream(includedFile);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(this.digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void validateAttributes() {
        if (this.fileSets.isEmpty()) {
            throw new BuildException("Specify at least one fileset.");
        }
        if (null == this.destFile) {
            throw new BuildException("Specify a destfile.");
        }
    }
}

