/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.ant.tasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;

public class Cat
extends Task {
    private File destFile = null;
    private String orderBy = null;
    private boolean filtering = false;
    private boolean append = false;
    private int verbosity = 3;
    private boolean forceOverwrite = false;
    private Vector filesets = new Vector();
    private Vector filterSets = new Vector();
    private String ORDER_BY_PATH = "path";
    private static final int BUFFER_SIZE = 32768;

    public void setAppend(boolean v) {
        this.append = v;
    }

    public void setDestFile(File argDestFile) {
        this.destFile = argDestFile;
    }

    public void setOrderBy(String argOrderBy) {
        this.orderBy = argOrderBy;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setFiltering(boolean filtering) {
        this.filtering = filtering;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        this.doFileOperations();
    }

    private void validateAttributes() {
        if (this.filesets.size() == 0) {
            throw new BuildException("Specify at least one fileset.");
        }
        if (this.destFile == null) {
            throw new BuildException("Specify a destfile.");
        }
        if (this.orderBy != null && !this.ORDER_BY_PATH.equalsIgnoreCase(this.orderBy)) {
            throw new BuildException("Specify a valid orderby ('path'), or none.");
        }
    }

    private OutputStream openOutputStream() throws IOException {
        File parent = new File(this.destFile.getParent());
        if (!parent.exists()) {
            if (!parent.mkdirs()) {
                this.log("Unable to create directory " + parent.getAbsolutePath(), 0);
            } else {
                this.log("Created directory " + parent.getAbsolutePath(), this.verbosity);
            }
        }
        return new FileOutputStream(this.destFile.getPath(), this.append);
    }

    private void doFileOperations() {
        try {
            List srcFiles = this.handleFileSets();
            if (srcFiles == null) {
                return;
            }
            FilterSetCollection filters = this.handleFilterSets();
            this.log("Concatenating " + srcFiles.size() + (srcFiles.size() == 1 ? " file to " : " files to ") + this.destFile.getAbsolutePath());
            this.catFiles(srcFiles, filters);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private List handleFileSets() {
        Vector<File> srcFiles = new Vector<File>();
        boolean foundNewer = false;
        Iterator filesetsIterator = this.filesets.iterator();
        while (filesetsIterator.hasNext()) {
            FileSet fs = (FileSet)filesetsIterator.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File baseDir = fs.getDir(this.project);
            Object[] srcFilesArray = ds.getIncludedFiles();
            if (this.ORDER_BY_PATH.equalsIgnoreCase(this.orderBy)) {
                Arrays.sort(srcFilesArray);
            }
            long destModified = this.destFile.lastModified();
            for (int j = 0; j < srcFilesArray.length; ++j) {
                File srcFile = new File(baseDir, (String)srcFilesArray[j]);
                if (srcFile.equals(this.destFile)) {
                    this.log("Skipping self-concatenation of " + srcFile, this.verbosity);
                    continue;
                }
                if (!foundNewer && srcFile.lastModified() > destModified) {
                    foundNewer = true;
                }
                srcFiles.add(srcFile);
            }
        }
        if (!this.forceOverwrite && !foundNewer) {
            srcFiles = null;
        }
        return srcFiles;
    }

    private FilterSetCollection handleFilterSets() {
        FilterSetCollection executionFilters = new FilterSetCollection();
        if (this.filtering) {
            executionFilters.addFilterSet(this.project.getGlobalFilterSet());
        }
        Enumeration filterEnum = this.filterSets.elements();
        while (filterEnum.hasMoreElements()) {
            executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
        }
        return executionFilters;
    }

    private void catFiles(List srcFiles, FilterSetCollection filters) throws IOException {
        OutputStream out = this.openOutputStream();
        Iterator srcFilesIterator = srcFiles.iterator();
        while (srcFilesIterator.hasNext()) {
            File srcFile = (File)srcFilesIterator.next();
            this.log("Concatenating " + srcFile + " to " + this.destFile, this.verbosity);
            FileInputStream in = new FileInputStream(srcFile);
            this.catStream(in, out, filters);
            in.close();
        }
        out.close();
    }

    private void catStream(InputStream in, OutputStream out, FilterSetCollection filters) throws IOException {
        if (filters != null && filters.hasFilters()) {
            BufferedReader input = new BufferedReader(new InputStreamReader(in));
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter(out));
            String line = input.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    output.newLine();
                } else {
                    String newline = filters.replaceTokens(line);
                    output.write(newline);
                    output.newLine();
                }
                line = input.readLine();
            }
            output.flush();
        } else {
            int read;
            byte[] buffer = new byte[32768];
            while (-1 != (read = in.read(buffer, 0, 32768))) {
                out.write(buffer, 0, read);
            }
        }
    }
}

