/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.NoPermissionException;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.util.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.list.TransformedList;

public class FileDocument
extends Document {
    public static final int TYPE_ID = 8;

    FileDocument(FileDocumentDomainObject document, ContentManagementSystem contentManagementSystem) {
        super((DocumentDomainObject)document, contentManagementSystem);
    }

    private FileDocumentDomainObject getInternalFileDocument() {
        return (FileDocumentDomainObject)this.getInternal();
    }

    public FileDocumentFile getFile(String fileId) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return new FileDocumentFile(this.getInternalFileDocument().getFile(fileId));
    }

    public FileDocumentFile removeFile(String fileId) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        return new FileDocumentFile(this.getInternalFileDocument().removeFile(fileId));
    }

    public FileDocumentFile[] getFiles() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        Map filesMap = this.getInternalFileDocument().getFiles();
        List files = TransformedList.decorate(new ArrayList(filesMap.size()), (Transformer)new Transformer(){

            public Object transform(Object input) {
                return new FileDocumentFile((FileDocumentDomainObject.FileDocumentFile)input);
            }
        });
        files.addAll(filesMap.values());
        return files.toArray(new FileDocumentFile[files.size()]);
    }

    public FileDocumentFile getFileOrDefault(String fileId) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return new FileDocumentFile(this.getInternalFileDocument().getFileOrDefault(fileId));
    }

    public String getDefaultFileId() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.getInternalFileDocument().getDefaultFileId();
    }

    public FileDocumentFile getDefaultFile() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return new FileDocumentFile(this.getInternalFileDocument().getDefaultFile());
    }

    public void addFile(String fileId, FileDocumentFile file) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.getInternalFileDocument().addFile(fileId, file.getInternal());
    }

    private static class DataSourceInputStreamSource
    implements InputStreamSource {
        private final DataSource dataSource;

        private DataSourceInputStreamSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public InputStream getInputStream() throws IOException {
            return this.dataSource.getInputStream();
        }

        public long getSize() throws IOException {
            return 0L;
        }
    }

    private static class FileDocumentDataSource
    implements DataSource {
        private FileDocumentDomainObject.FileDocumentFile file;

        private FileDocumentDataSource(FileDocumentDomainObject.FileDocumentFile file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return this.file.getInputStreamSource().getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            return this.file.getMimeType();
        }

        public String getName() {
            return this.file.getFilename();
        }

        private FileDocumentDomainObject.FileDocumentFile getFile() {
            return this.file;
        }
    }

    public static class FileDocumentFile
    implements DataSource {
        private FileDocumentDataSource dataSource;

        public FileDocumentFile(DataSource dataSource) {
            FileDocumentDomainObject.FileDocumentFile file = new FileDocumentDomainObject.FileDocumentFile();
            file.setFilename(dataSource.getName());
            file.setMimeType(dataSource.getContentType());
            file.setInputStreamSource((InputStreamSource)new DataSourceInputStreamSource(dataSource));
            this.dataSource = new FileDocumentDataSource(file);
        }

        public FileDocumentFile(FileDocumentDomainObject.FileDocumentFile file) {
            this.dataSource = new FileDocumentDataSource(file);
        }

        public FileDocumentDomainObject.FileDocumentFile getInternal() {
            return this.dataSource.getFile();
        }

        public String getContentType() {
            return this.dataSource.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.dataSource.getInputStream();
        }

        public String getName() {
            return this.dataSource.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getSize() throws IOException {
            return this.dataSource.getFile().getInputStreamSource().getSize();
        }

        public String getId() {
            return this.dataSource.getFile().getId();
        }
    }
}

