/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.BadQueryException;
import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.CategoryTypeAlreadyExistsException;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.FileDocument;
import com.imcode.imcms.api.LuceneParsedQuery;
import com.imcode.imcms.api.MaxCategoriesOfTypeExceededException;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.SearchException;
import com.imcode.imcms.api.SearchQuery;
import com.imcode.imcms.api.Section;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.UrlDocument;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.XmlDocumentBuilder;
import imcode.server.document.index.IndexException;
import imcode.server.document.textdocument.TextDocumentDomainObject;

public class DocumentService {
    private ContentManagementSystem contentManagementSystem;

    public DocumentService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    static Document wrapDocumentDomainObject(DocumentDomainObject document, ContentManagementSystem contentManagementSystem) {
        ApiWrappingDocumentVisitor apiWrappingDocumentVisitor = new ApiWrappingDocumentVisitor(contentManagementSystem);
        document.accept((DocumentVisitor)apiWrappingDocumentVisitor);
        return apiWrappingDocumentVisitor.getDocument();
    }

    public Document getDocument(int documentId) throws NoPermissionException {
        DocumentDomainObject doc = this.getDocumentMapper().getDocument(documentId);
        Document result = null;
        if (null != doc) {
            result = DocumentService.wrapDocumentDomainObject(doc, this.contentManagementSystem);
            this.getSecurityChecker().hasAtLeastDocumentReadPermission(result);
        }
        return result;
    }

    public TextDocument getTextDocument(int documentId) throws NoPermissionException {
        return (TextDocument)this.getDocument(documentId);
    }

    public UrlDocument getUrlDocument(int documentId) throws NoPermissionException {
        return (UrlDocument)this.getDocument(documentId);
    }

    public TextDocument createNewTextDocument(Document parent) throws NoPermissionException {
        return (TextDocument)this.createNewDocument(2, parent);
    }

    public UrlDocument createNewUrlDocument(Document parent) throws NoPermissionException {
        return (UrlDocument)this.createNewDocument(5, parent);
    }

    public FileDocument createNewFileDocument(Document parent) throws NoPermissionException {
        return (FileDocument)this.createNewDocument(8, parent);
    }

    private Document createNewDocument(int doctype, Document parent) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(parent);
        return DocumentService.wrapDocumentDomainObject(this.getDocumentMapper().createDocumentOfTypeFromParent(doctype, parent.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal()), this.contentManagementSystem);
    }

    public synchronized void saveChanges(Document document) throws NoPermissionException, SaveException {
        this.getSecurityChecker().hasEditPermission(document);
        try {
            if (0 == document.getId()) {
                this.getDocumentMapper().saveNewDocument(document.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal());
            } else {
                this.getDocumentMapper().saveDocument(document.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal());
            }
        }
        catch (MaxCategoryDomainObjectsOfTypeExceededException e) {
            throw new MaxCategoriesOfTypeExceededException(e);
        }
    }

    public Category getCategory(CategoryType categoryType, String categoryName) {
        CategoryDomainObject category = this.getDocumentMapper().getCategory(categoryType.getInternal(), categoryName);
        if (null != category) {
            return new Category(category);
        }
        return null;
    }

    public Category getCategory(int categoryId) {
        CategoryDomainObject category = this.getDocumentMapper().getCategoryById(categoryId);
        if (null != category) {
            return new Category(category);
        }
        return null;
    }

    public CategoryType getCategoryType(int categoryTypeId) {
        CategoryTypeDomainObject categoryType = this.getDocumentMapper().getCategoryTypeById(categoryTypeId);
        return this.returnCategoryTypeAPIObjectOrNull(categoryType);
    }

    public CategoryType getCategoryType(String categoryTypeName) {
        CategoryTypeDomainObject categoryType = this.getDocumentMapper().getCategoryType(categoryTypeName);
        return this.returnCategoryTypeAPIObjectOrNull(categoryType);
    }

    private CategoryType returnCategoryTypeAPIObjectOrNull(CategoryTypeDomainObject categoryType) {
        if (null != categoryType) {
            return new CategoryType(categoryType);
        }
        return null;
    }

    public Category[] getAllCategoriesOfType(CategoryType categoryType) {
        CategoryDomainObject[] categoryDomainObjects = this.getDocumentMapper().getAllCategoriesOfType(categoryType.getInternal());
        Category[] categories = new Category[categoryDomainObjects.length];
        for (int i = 0; i < categoryDomainObjects.length; ++i) {
            CategoryDomainObject categoryDomainObject = categoryDomainObjects[i];
            categories[i] = new Category(categoryDomainObject);
        }
        return categories;
    }

    public CategoryType[] getAllCategoryTypes() {
        CategoryTypeDomainObject[] categoryTypeDomainObjects = this.getDocumentMapper().getAllCategoryTypes();
        CategoryType[] categoryTypes = new CategoryType[categoryTypeDomainObjects.length];
        for (int i = 0; i < categoryTypeDomainObjects.length; ++i) {
            CategoryTypeDomainObject categoryTypeDomainObject = categoryTypeDomainObjects[i];
            categoryTypes[i] = new CategoryType(categoryTypeDomainObject);
        }
        return categoryTypes;
    }

    public CategoryType createNewCategoryType(String name, int maxChoices) throws NoPermissionException, CategoryTypeAlreadyExistsException {
        this.getSecurityChecker().isSuperAdmin();
        if (this.getDocumentMapper().isUniqueCategoryTypeName(name)) {
            CategoryTypeDomainObject newCategoryTypeDO = this.getDocumentMapper().addCategoryTypeToDb(name, maxChoices);
            return new CategoryType(newCategoryTypeDO);
        }
        throw new CategoryTypeAlreadyExistsException("A category with name " + name + " already exists.");
    }

    private SecurityChecker getSecurityChecker() {
        return this.contentManagementSystem.getSecurityChecker();
    }

    public Category createNewCategory(String name, String description, String imageUrl, CategoryType categoryType) throws NoPermissionException, CategoryAlreadyExistsException {
        this.getSecurityChecker().isSuperAdmin();
        CategoryDomainObject newCategory = new CategoryDomainObject(0, name, description, imageUrl, categoryType.getInternal());
        newCategory = this.getDocumentMapper().addCategory(newCategory);
        return new Category(newCategory);
    }

    public Section getSection(int sectionId) {
        SectionDomainObject section = this.getDocumentMapper().getSectionById(sectionId);
        if (null == section) {
            return null;
        }
        return new Section(section);
    }

    public Section getSection(String name) {
        SectionDomainObject section = this.getDocumentMapper().getSectionByName(name);
        if (null == section) {
            return null;
        }
        return new Section(section);
    }

    public Document[] search(SearchQuery query) throws SearchException {
        try {
            DocumentDomainObject[] documentDomainObjects = this.getDocumentMapper().getDocumentIndex().search(query.getQuery(), this.contentManagementSystem.getCurrentUser().getInternal());
            Document[] documents = new Document[documentDomainObjects.length];
            for (int i = 0; i < documentDomainObjects.length; ++i) {
                DocumentDomainObject documentDomainObject = documentDomainObjects[i];
                documents[i] = DocumentService.wrapDocumentDomainObject(documentDomainObject, this.contentManagementSystem);
            }
            return documents;
        }
        catch (IndexException e) {
            throw new SearchException(e);
        }
    }

    private DocumentMapper getDocumentMapper() {
        return this.contentManagementSystem.getInternal().getDocumentMapper();
    }

    public SearchQuery parseLuceneSearchQuery(String query) throws BadQueryException {
        return new LuceneParsedQuery(query);
    }

    public org.w3c.dom.Document getXmlDomForDocument(Document document) {
        XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
        xmlDocumentBuilder.addDocument(document.getInternal());
        org.w3c.dom.Document xmlDocument = xmlDocumentBuilder.getXmlDocument();
        return xmlDocument;
    }

    public void saveCategory(Category category) throws NoPermissionException, CategoryAlreadyExistsException {
        this.getSecurityChecker().isSuperAdmin();
        this.getDocumentMapper().saveCategory(category.getInternal());
    }

    static class ApiWrappingDocumentVisitor
    extends DocumentVisitor {
        private ContentManagementSystem contentManagementSystem;
        private Document document;

        ApiWrappingDocumentVisitor(ContentManagementSystem contentManagementSystem) {
            this.contentManagementSystem = contentManagementSystem;
        }

        public void visitFileDocument(FileDocumentDomainObject fileDocument) {
            this.document = new FileDocument(fileDocument, this.contentManagementSystem);
        }

        public void visitTextDocument(TextDocumentDomainObject textDocument) {
            this.document = new TextDocument(textDocument, this.contentManagementSystem);
        }

        public void visitUrlDocument(UrlDocumentDomainObject urlDocument) {
            this.document = new UrlDocument(urlDocument, this.contentManagementSystem);
        }

        protected void visitOtherDocument(DocumentDomainObject otherDocument) {
            this.document = new Document(otherDocument, this.contentManagementSystem);
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

