/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.log;

import imcode.util.log.DailyRollingFileAppender;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TestDailyRollingFileAppender
extends TestCase {
    private static final String DATE_PATTERN = ".yyyy-MM-dd-HH-mm";

    public TestDailyRollingFileAppender(String name) {
        super(name);
    }

    public void setUp() {
        TestDailyRollingFileAppender.getTempFile().delete();
    }

    public void testLogFileCreated() throws IOException {
        TestDailyRollingFileAppender.createAppender(TestDailyRollingFileAppender.getTempFile());
        TestDailyRollingFileAppender.assertTrue((boolean)TestDailyRollingFileAppender.getTempFile().exists());
    }

    public void testLineLogged() throws IOException {
        DailyRollingFileAppender appender = TestDailyRollingFileAppender.createAppender(TestDailyRollingFileAppender.getTempFile());
        appender.doAppend(this.getLoggingEvent());
        appender.close();
        TestDailyRollingFileAppender.assertTrue((TestDailyRollingFileAppender.getTempFile().length() > 0L ? 1 : 0) != 0);
    }

    private LoggingEvent getLoggingEvent() {
        return new LoggingEvent(MockLogger.class.getName(), (Category)new MockLogger("mock"), Priority.DEBUG, (Object)"Test", null);
    }

    private static DailyRollingFileAppender createAppender(File filePath) throws IOException {
        String fileName = filePath.getPath();
        SimpleLayout layout = new SimpleLayout();
        DailyRollingFileAppender appender = new DailyRollingFileAppender((Layout)layout, fileName, DATE_PATTERN);
        return appender;
    }

    private static File getTempFile() {
        String tmpDir = "tmp";
        File filePath = new File(tmpDir, TestDailyRollingFileAppender.class.getName() + ".test");
        return filePath;
    }

    private class MockLogger
    extends Logger {
        private MockLogger(String name) {
            super(name);
        }
    }
}

