/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.io;

import imcode.util.io.FileUtility;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;

public class TestFileUtility
extends TestCase {
    private File rootDir;
    private File subDir1;
    private File subDir2;
    private File subSubDir;

    public void setUp() throws Exception {
        this.rootDir = new File("test");
        FileUtils.deleteDirectory((File)this.rootDir);
        FileUtils.forceMkdir((File)this.rootDir);
        this.subDir1 = new File(this.rootDir, "subdir1");
        FileUtils.forceMkdir((File)this.subDir1);
        this.subDir2 = new File(this.rootDir, "subdir2");
        FileUtils.forceMkdir((File)this.subDir2);
        this.subSubDir = new File(this.subDir1, "subsubdir");
        FileUtils.forceMkdir((File)this.subSubDir);
    }

    protected void tearDown() throws Exception {
        FileUtils.forceDelete((File)this.rootDir);
    }

    public void testUnescapeFilename() throws Exception {
        TestFileUtility.assertEquals((String)"Space", (String)" ", (String)FileUtility.unescapeFilename("_0020"));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)FileUtility.unescapeFilename("_00c5_00c4_00d6_00e5_00e4_00f6"));
    }

    public void testEscapeFilename() throws Exception {
        TestFileUtility.assertEquals((String)"Space", (String)"_0020", (String)FileUtility.escapeFilename(" "));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)"_00c5_00c4_00d6_00e5_00e4_00f6", (String)FileUtility.escapeFilename("\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6"));
    }

    public void testEscapes() {
        TestFileUtility.assertEquals((String)"Space", (String)" ", (String)FileUtility.unescapeFilename(FileUtility.escapeFilename(" ")));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6", (String)"\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6", (String)FileUtility.unescapeFilename(FileUtility.escapeFilename("\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6")));
    }

    public void testDirectoryIsAncestorOfOrEqualTo() throws IOException {
        TestFileUtility.assertTrue((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, this.subSubDir));
        TestFileUtility.assertTrue((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, this.rootDir));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subDir1, this.rootDir));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subSubDir, this.subDir1));
    }

    public void testRelativizeFile() throws Exception {
        File relativeFile = FileUtility.relativizeFile(this.rootDir, this.subSubDir);
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, relativeFile));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subDir1, relativeFile));
        TestFileUtility.assertEquals((String)this.subDir1.getName(), (String)relativeFile.getParentFile().getName());
        TestFileUtility.assertNull((Object)relativeFile.getParentFile().getParentFile());
    }

    public void testBackupRename() throws IOException {
        TestFileUtility.assertTrue((boolean)this.subDir1.exists());
        TestFileUtility.assertTrue((boolean)this.subDir2.exists());
        FileUtility.backupRename(this.subDir1, this.subDir2);
        TestFileUtility.assertFalse((boolean)this.subDir1.exists());
        TestFileUtility.assertTrue((boolean)this.subDir2.exists());
    }
}

