/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.map.AbstractHashedMap;

public class FrequencyOrderedBag {
    private List entries = new AbstractList(){
        private List list = new ArrayList();

        public Object get(int index) {
            return this.list.get(index);
        }

        public Object set(int index, Object element) {
            FrequencyMap.Entry link = (FrequencyMap.Entry)((Object)element);
            link.index = index;
            return this.list.set(index, link);
        }

        public void add(int index, Object element) {
            FrequencyMap.Entry link = (FrequencyMap.Entry)((Object)element);
            link.index = index;
            this.list.add(index, link);
        }

        public Object remove(int index) {
            Object result = this.list.remove(index);
            for (int i = index; i < this.size(); ++i) {
                FrequencyMap.Entry entry = (FrequencyMap.Entry)((Object)this.list.get(i));
                entry.index = i;
            }
            return result;
        }

        public int size() {
            return this.list.size();
        }
    };
    private final FrequencyMap map = new FrequencyMap(this.entries, 10);
    private AbstractList keys = new AbstractList(){

        public Object get(int index) {
            FrequencyMap.Entry entry = (FrequencyMap.Entry)((Object)FrequencyOrderedBag.this.entries.get(index));
            return entry.getKey();
        }

        public int size() {
            return FrequencyOrderedBag.this.entries.size();
        }
    };

    public int getFrequency(Object key) {
        return (Integer)this.map.get(key);
    }

    public int add(Object key) {
        return this.map.add(key);
    }

    public List asList() {
        return this.keys;
    }

    public int size() {
        return this.map.size();
    }

    public void add(Object key, int count) {
        this.map.add(key, count);
    }

    public String toString() {
        return this.entries.toString();
    }

    public int remove(Object key) {
        return (Integer)this.map.remove(key);
    }

    private static class FrequencyMap
    extends AbstractHashedMap {
        private final List entries;

        FrequencyMap(List entries, int i) {
            super(i);
            this.entries = entries;
        }

        protected AbstractHashedMap.HashEntry createEntry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
            return new Entry(next, hashCode, key, value);
        }

        public Object get(Object key) {
            Integer frequency = (Integer)super.get(key);
            if (null == frequency) {
                frequency = new Integer(0);
            }
            return frequency;
        }

        public Object put(Object key, Object value) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("" + value);
            }
            return super.put(key, value);
        }

        protected void updateEntry(AbstractHashedMap.HashEntry entry, Object newValue) {
            Entry frequencyEntry = (Entry)entry;
            super.updateEntry((AbstractHashedMap.HashEntry)frequencyEntry, newValue);
            this.moveInPlace(frequencyEntry);
        }

        private void moveInPlace(Entry frequencyEntry) {
            while (frequencyEntry.index > 0 && frequencyEntry.getFrequency() >= this.getFrequencyAt(frequencyEntry.index - 1)) {
                int entryIndex = frequencyEntry.index;
                int previousEntryIndex = entryIndex - 1;
                this.entries.set(entryIndex, this.entries.set(previousEntryIndex, frequencyEntry));
            }
        }

        private int getFrequencyAt(int index) {
            Entry entry = (Entry)((Object)this.entries.get(index));
            return entry.getFrequency();
        }

        protected void addEntry(AbstractHashedMap.HashEntry entry, int hashIndex) {
            super.addEntry(entry, hashIndex);
            this.entries.add(entry);
            this.moveInPlace((Entry)entry);
        }

        public int add(Object key) {
            return this.add(key, 1);
        }

        private int add(Object key, int nCopies) {
            Integer frequency;
            Entry entry = (Entry)this.getEntry(key);
            if (null == entry) {
                frequency = new Integer(nCopies);
                this.put(key, frequency);
            } else {
                frequency = (Integer)entry.getValue();
                this.updateEntry(entry, new Integer(frequency + nCopies));
            }
            return frequency;
        }

        public Object remove(Object key) {
            Entry entry = (Entry)this.getEntry(key);
            if (null != entry) {
                this.entries.remove(entry.index);
                return (Integer)super.remove(key);
            }
            return new Integer(0);
        }

        private static class Entry
        extends AbstractHashedMap.HashEntry {
            private int index = -1;

            private Entry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value) {
                super(next, hashCode, key, value);
            }

            private int getFrequency() {
                return (Integer)this.value;
            }
        }
    }
}

