/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;
import org.apache.commons.lang.ArrayUtils;

public class TestUserDomainObject
extends TestCase {
    private UserDomainObject user;

    protected void setUp() throws Exception {
        super.setUp();
        this.user = new UserDomainObject();
    }

    public void testClone() {
        UserDomainObject clone = (UserDomainObject)this.user.clone();
        TestUserDomainObject.assertNotSame((String)"Roles cloned", (Object)clone.roleIds, (Object)this.user.roleIds);
        TestUserDomainObject.assertNotSame((String)"Useradmin roles cloned", (Object)clone.userAdminRoleIds, (Object)this.user.userAdminRoleIds);
    }

    public void testUserAlwaysHasUsersRole() {
        TestUserDomainObject.assertTrue((boolean)this.user.hasRoleId(RoleId.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoleIds(), (Object)RoleId.USERS));
        this.user.removeRoleId(RoleId.USERS);
        TestUserDomainObject.assertTrue((boolean)this.user.hasRoleId(RoleId.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoleIds(), (Object)RoleId.USERS));
        this.user.setRoleIds(new RoleId[0]);
        TestUserDomainObject.assertTrue((boolean)this.user.hasRoleId(RoleId.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoleIds(), (Object)RoleId.USERS));
    }

    public void testCanAddDocumentToAnyMenu() {
        TextDocumentDomainObject textDocument = new TextDocumentDomainObject();
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        RoleId readRole = new RoleId(3);
        textDocument.setDocumentPermissionSetTypeForRoleId(readRole, DocumentPermissionSetTypeDomainObject.READ);
        this.user.addRoleId(readRole);
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        textDocument.setLinkableByOtherUsers(true);
        TestUserDomainObject.assertTrue((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        textDocument.setLinkableByOtherUsers(false);
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        RoleId editRole = new RoleId(4);
        textDocument.setDocumentPermissionSetTypeForRoleId(editRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.user.addRoleId(editRole);
        TestUserDomainObject.assertTrue((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
    }
}

