/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.user.RoleId;
import imcode.server.user.RolePermissionDomainObject;
import imcode.util.LocalizedMessage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RoleDomainObject
implements Serializable,
Comparable {
    public static final RolePermissionDomainObject PASSWORD_MAIL_PERMISSION = new RolePermissionDomainObject(1, new LocalizedMessage("role_permission/password_by_email/description"));
    public static final RolePermissionDomainObject ADMIN_PAGES_PERMISSION = new RolePermissionDomainObject(4, new LocalizedMessage("role_permission/admin_pages_access/desciption"));
    private static final RolePermissionDomainObject[] ALL_ROLE_PERMISSIONS = new RolePermissionDomainObject[]{PASSWORD_MAIL_PERMISSION, ADMIN_PAGES_PERMISSION};
    private RoleId id;
    private String name;
    private int adminRoleId;
    private Set permissions = new HashSet();

    public RoleDomainObject(String name) {
        this(new RoleId(0), name, 0);
    }

    public RoleDomainObject(RoleId roleId, String roleName, int adminRoleId) {
        this.id = roleId;
        this.name = roleName;
        this.adminRoleId = adminRoleId;
    }

    public void setId(RoleId id) {
        this.id = id;
    }

    public RoleId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleDomainObject)) {
            return false;
        }
        RoleDomainObject roleDomainObject = (RoleDomainObject)o;
        if (this.isAdminRole() || roleDomainObject.isAdminRole()) {
            return this.adminRoleId == roleDomainObject.adminRoleId;
        }
        return this.id.equals(roleDomainObject.id);
    }

    public int hashCode() {
        if (this.isAdminRole()) {
            return -this.adminRoleId;
        }
        return this.id.intValue();
    }

    public String toString() {
        return "(role " + this.id + " \"" + this.name + "\" " + this.adminRoleId + ")";
    }

    public boolean isAdminRole() {
        return 0 != this.adminRoleId;
    }

    public int compareTo(Object o) {
        return this.name.compareToIgnoreCase(((RoleDomainObject)o).name);
    }

    public void addPermission(RolePermissionDomainObject permission) {
        this.permissions.add(permission);
    }

    public boolean hasPermission(RolePermissionDomainObject permission) {
        return this.permissions.contains(permission);
    }

    public void removePermission(RolePermissionDomainObject permission) {
        this.permissions.remove(permission);
    }

    public RolePermissionDomainObject[] getPermissions() {
        return this.permissions.toArray(new RolePermissionDomainObject[this.permissions.size()]);
    }

    public void addUnionOfPermissionIdsToRole(int unionOfRolePermissionIds) {
        for (int i = 0; i < ALL_ROLE_PERMISSIONS.length; ++i) {
            RolePermissionDomainObject permission = ALL_ROLE_PERMISSIONS[i];
            if (!this.bitIsSet(unionOfRolePermissionIds, permission.getId())) continue;
            this.addPermission(permission);
        }
    }

    private boolean bitIsSet(int unionOfRolePermissionIds, int bitValue) {
        return 0 != (unionOfRolePermissionIds & bitValue);
    }

    public static RolePermissionDomainObject[] getAllRolePermissions() {
        return ALL_ROLE_PERMISSIONS;
    }
}

