/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ImageSize;
import imcode.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;

public abstract class ImageSource
implements Serializable {
    public static final int IMAGE_TYPE_ID__NULL = -1;
    public static final int IMAGE_TYPE_ID__IMAGES_PATH_RELATIVE_PATH = 0;
    public static final int IMAGE_TYPE_ID__FILE_DOCUMENT = 1;
    private ImageSize cachedImageSize;
    private Date cachedImageSizeTime;

    abstract InputStreamSource getInputStreamSource();

    abstract String getUrlPathRelativeToContextPath();

    public abstract String toStorageString();

    public abstract int getTypeId();

    public abstract Date getModifiedDatetime();

    ImageSize getImageSize() throws IOException {
        if (this.getInputStreamSource().getSize() > 0L) {
            Date modifiedDatetime = this.getModifiedDatetime();
            if (this.cachedImageSizeTime == null || modifiedDatetime.after(this.cachedImageSizeTime)) {
                this.cachedImageSize = this.getNonCachedImageSize();
                this.cachedImageSizeTime = modifiedDatetime;
            }
            return this.cachedImageSize;
        }
        return new ImageSize(0, 0);
    }

    ImageSize getNonCachedImageSize() throws IOException {
        return ImageSize.fromInputStream((InputStream)this.getInputStreamSource().getInputStream());
    }

    public boolean isEmpty() {
        try {
            return this.getInputStreamSource().getSize() <= 0L;
        }
        catch (IOException e) {
            return true;
        }
    }
}

