/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.imcms.db.DefaultProcedureExecutor;
import com.imcode.imcms.db.ProcedureExecutor;
import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Config;
import imcode.server.ImcmsServices;
import imcode.server.LanguageMapper;
import imcode.server.PhaseQueryFixingDocumentIndex;
import imcode.server.SystemData;
import imcode.server.WebAppGlobalConstants;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.RebuildingDirectoryIndex;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.TextDocumentParser;
import imcode.server.user.Authenticator;
import imcode.server.user.ExternalizedImcmsAuthenticatorAndUserRegistry;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.LdapUserAndRoleRegistry;
import imcode.server.user.RoleGetter;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import imcode.util.CachingFileLoader;
import imcode.util.Parser;
import imcode.util.Prefs;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import imcode.util.net.SMTP;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public final class DefaultImcmsServices
implements ImcmsServices {
    private final Database database;
    private TextDocumentParser textDocParser;
    private Config config;
    private static final int DEFAULT_STARTDOCUMENT = 1001;
    private SystemData sysData;
    private Date sessionCounterDate;
    private int sessionCounter = 0;
    private CachingFileLoader fileLoader = new CachingFileLoader();
    private static final Logger mainLog = Logger.getLogger((String)"com.imcode.imcms.log.main");
    private static final Logger log = Logger.getLogger((String)DefaultImcmsServices.class.getName());
    private static final String EXTERNAL_AUTHENTICATOR_LDAP = "LDAP";
    private static final String EXTERNAL_USER_AND_ROLE_MAPPER_LDAP = "LDAP";
    private ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper;
    private ExternalizedImcmsAuthenticatorAndUserRegistry externalizedImcmsAuthAndMapper;
    private DocumentMapper documentMapper;
    private TemplateMapper templateMapper;
    private Map languagePropertiesMap = new HashMap();
    private KeyStore keyStore;
    private Map velocityEngines = new TreeMap();
    private LanguageMapper languageMapper;
    private ProcedureExecutor procedureExecutor;

    public DefaultImcmsServices(DataSource dataSource, Properties props) {
        this.database = new DataSourceDatabase(dataSource);
        this.procedureExecutor = new DefaultProcedureExecutor(this.database);
        this.initConfig(props);
        this.initKeyStore();
        this.initSysData();
        this.initSessionCounter();
        this.languageMapper = new LanguageMapper(this.database, this.config.getDefaultLanguage());
        this.initAuthenticatorsAndUserAndRoleMappers(props);
        this.initDocumentMapper();
        this.initTemplateMapper();
        this.initTextDocParser();
    }

    private void initKeyStore() {
        String keyStoreType = this.config.getKeyStoreType();
        if (StringUtils.isBlank((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        try {
            this.keyStore = KeyStore.getInstance(keyStoreType);
            this.keyStore.load(null, null);
        }
        catch (GeneralSecurityException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
        String keyStorePath = this.config.getKeyStorePath();
        if (StringUtils.isNotBlank((String)keyStorePath)) {
            File keyStoreFile = FileUtility.getFileFromWebappRelativePath(keyStorePath);
            try {
                this.keyStore.load(new FileInputStream(keyStoreFile), null);
            }
            catch (Exception e) {
                log.error((Object)("Failed to load keystore from path " + keyStoreFile), (Throwable)e);
            }
        }
    }

    private void initTextDocParser() {
        this.textDocParser = new TextDocumentParser(this);
    }

    private void initSysData() {
        this.sysData = this.getSystemDataFromDb();
    }

    private void initConfig(Properties props) {
        this.config = DefaultImcmsServices.createConfigFromProperties(props);
    }

    private static Config createConfigFromProperties(Properties props) {
        Config config = new Config();
        ConvertUtils.register((Converter)new WebappRelativeFileConverter(), (Class)File.class);
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)config);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (null == propertyDescriptor.getWriteMethod()) continue;
            String uncapitalizedPropertyName = propertyDescriptor.getName();
            String capitalizedPropertyName = StringUtils.capitalize((String)uncapitalizedPropertyName);
            String propertyValue = props.getProperty(capitalizedPropertyName);
            if (null != propertyValue) {
                try {
                    BeanUtils.setProperty((Object)config, (String)uncapitalizedPropertyName, (Object)propertyValue);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to set property " + capitalizedPropertyName), e.getCause());
                    continue;
                }
            }
            try {
                String setPropertyValue = BeanUtils.getProperty((Object)config, (String)uncapitalizedPropertyName);
                if (null != setPropertyValue) {
                    log.info((Object)(capitalizedPropertyName + " = " + setPropertyValue));
                    continue;
                }
                log.warn((Object)(capitalizedPropertyName + " not set."));
                continue;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        return config;
    }

    private void initSessionCounter() {
        try {
            this.sessionCounter = this.getSessionCounterFromDb();
            this.sessionCounterDate = this.getSessionCounterDateFromDb();
        }
        catch (NumberFormatException ex) {
            log.fatal((Object)"Failed to get SessionCounter from db.", (Throwable)ex);
            throw ex;
        }
        log.info((Object)("SessionCounter: " + this.sessionCounter));
        log.info((Object)("SessionCounterDate: " + this.sessionCounterDate));
    }

    private Date getSessionCounterDateFromDb() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Object[] parameters = new String[]{};
            return dateFormat.parse((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 2", parameters, Utility.SINGLE_STRING_HANDLER)));
        }
        catch (ParseException ex) {
            log.fatal((Object)"Failed to get SessionCounterDate from db.", (Throwable)ex);
            throw new UnhandledException((Throwable)ex);
        }
    }

    private int getSessionCounterFromDb() {
        Object[] parameters = new String[]{};
        return Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 1", parameters, Utility.SINGLE_STRING_HANDLER)));
    }

    private void initDocumentMapper() {
        File indexDirectory = new File(this.getRealContextPath(), "WEB-INF/index");
        this.documentMapper = new DocumentMapper(this, this.getDatabase());
        this.documentMapper.setDocumentIndex(new PhaseQueryFixingDocumentIndex(new RebuildingDirectoryIndex(indexDirectory, this.getConfig().getIndexingSchedulePeriodInMinutes(), new IndexDocumentFactory(this.getCategoryMapper()))));
    }

    private void initTemplateMapper() {
        this.templateMapper = new TemplateMapper(this);
    }

    private void initAuthenticatorsAndUserAndRoleMappers(Properties props) {
        String externalAuthenticatorName = props.getProperty("ExternalAuthenticator");
        String externalUserAndRoleMapperName = props.getProperty("ExternalUserAndRoleMapper");
        Authenticator externalAuthenticator = null;
        UserAndRoleRegistry externalUserAndRoleRegistry = null;
        boolean externalAuthenticatorIsSet = StringUtils.isNotBlank((String)externalAuthenticatorName);
        boolean externalUserAndRoleRegistryIsSet = StringUtils.isNotBlank((String)externalUserAndRoleMapperName);
        if (externalAuthenticatorIsSet && externalUserAndRoleRegistryIsSet) {
            log.info((Object)("ExternalAuthenticator: " + externalAuthenticatorName));
            log.info((Object)("ExternalUserAndRoleMapper: " + externalUserAndRoleMapperName));
            externalAuthenticator = this.initExternalAuthenticator(externalAuthenticatorName, props);
            externalUserAndRoleRegistry = this.initExternalUserAndRoleMapper(externalUserAndRoleMapperName, props);
            if (null == externalAuthenticator || null == externalUserAndRoleRegistry) {
                log.error((Object)"Failed to initialize both authenticator and user-and-role-documentMapper, using default implementations.");
                externalAuthenticator = null;
                externalUserAndRoleRegistry = null;
            }
        } else if (!externalAuthenticatorIsSet && !externalUserAndRoleRegistryIsSet) {
            log.info((Object)"ExternalAuthenticator not set.");
            log.info((Object)"ExternalUserAndRoleMapper not set.");
        } else {
            log.error((Object)"External authenticator and external usermapper should both be either set or not set. Using default implementation.");
            log.error((Object)"External authenticator and external usermapper should both be either set or not set. Using default implementation.");
        }
        this.imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper(this);
        this.externalizedImcmsAuthAndMapper = new ExternalizedImcmsAuthenticatorAndUserRegistry(this.imcmsAuthenticatorAndUserAndRoleMapper, externalAuthenticator, externalUserAndRoleRegistry, this.getLanguageMapper().getDefaultLanguage());
        this.externalizedImcmsAuthAndMapper.synchRolesWithExternal();
    }

    public synchronized int getSessionCounter() {
        return this.sessionCounter;
    }

    public String getSessionCounterDateAsString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(this.sessionCounterDate);
    }

    public UserDomainObject verifyUserByIpOrDefault(String remoteAddr) {
        UserDomainObject user = this.imcmsAuthenticatorAndUserAndRoleMapper.getUserByIpAddress(remoteAddr);
        if (null == user) {
            user = this.imcmsAuthenticatorAndUserAndRoleMapper.getDefaultUser();
        }
        UserDomainObject result = null;
        if (!user.isActive()) {
            this.logUserDeactivated(user);
        } else {
            result = user;
            this.logUserLoggedIn(user);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserDomainObject verifyUser(String login, String password) {
        NDC.push((String)"verifyUser");
        try {
            UserDomainObject result = null;
            boolean userAuthenticates = this.externalizedImcmsAuthAndMapper.authenticate(login, password);
            UserDomainObject user = this.externalizedImcmsAuthAndMapper.getUser(login);
            if (null == user) {
                mainLog.info((Object)("->User '" + login + "' failed to log in: User not found."));
            } else if (!user.isActive()) {
                this.logUserDeactivated(user);
            } else if (!userAuthenticates) {
                mainLog.info((Object)("->User '" + login + "' failed to log in: Wrong password."));
            } else {
                result = user;
                this.logUserLoggedIn(user);
            }
            UserDomainObject userDomainObject = result;
            return userDomainObject;
        }
        finally {
            NDC.pop();
        }
    }

    private void logUserDeactivated(UserDomainObject user) {
        mainLog.info((Object)("->User '" + user.getLoginName() + "' failed to log in: User deactivated."));
    }

    private void logUserLoggedIn(UserDomainObject user) {
        if (!user.isDefaultUser()) {
            mainLog.info((Object)("->User '" + user.getLoginName() + "' successfully logged in."));
        }
    }

    public synchronized void incrementSessionCounter() {
        ++this.sessionCounter;
        Object[] parameters = new String[]{"" + this.sessionCounter};
        ((Integer)this.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("UPDATE sys_data SET value = ? WHERE type_id = 1", parameters))).intValue();
    }

    private UserAndRoleRegistry initExternalUserAndRoleMapper(String externalUserAndRoleMapperName, Properties userAndRoleMapperPropertiesSubset) {
        UserAndRoleRegistry externalUserAndRoleRegistry = null;
        if (null == externalUserAndRoleMapperName) {
            externalUserAndRoleRegistry = null;
        } else if ("LDAP".equalsIgnoreCase(externalUserAndRoleMapperName)) {
            try {
                externalUserAndRoleRegistry = new LdapUserAndRoleRegistry(userAndRoleMapperPropertiesSubset);
            }
            catch (LdapUserAndRoleRegistry.LdapInitException e) {
                log.error((Object)"LdapUserAndRoleRegistry could not be created, using default user and role documentMapper.", (Throwable)e);
            }
        } else {
            externalUserAndRoleRegistry = (UserAndRoleRegistry)DefaultImcmsServices.createInstanceOfClass(externalUserAndRoleMapperName);
        }
        return externalUserAndRoleRegistry;
    }

    private Authenticator initExternalAuthenticator(String externalAuthenticatorName, Properties authenticatorPropertiesSubset) {
        Authenticator externalAuthenticator = null;
        try {
            if (null == externalAuthenticatorName) {
                externalAuthenticator = null;
            } else if ("LDAP".equalsIgnoreCase(externalAuthenticatorName)) {
                try {
                    externalAuthenticator = new LdapUserAndRoleRegistry(authenticatorPropertiesSubset);
                }
                catch (LdapUserAndRoleRegistry.LdapInitException e) {
                    log.error((Object)"LdapUserAndRoleRegistry could not be created, using default user and role documentMapper.", (Throwable)e);
                }
            } else {
                externalAuthenticator = (Authenticator)DefaultImcmsServices.createInstanceOfClass(externalAuthenticatorName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize external authenticator.", (Throwable)e);
        }
        return externalAuthenticator;
    }

    private static Object createInstanceOfClass(String className) {
        Object instance = null;
        try {
            instance = Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not create instance of class '" + className + "'."), (Throwable)e);
        }
        return instance;
    }

    public String parsePage(ParserParameters paramsToParse) throws IOException {
        return this.textDocParser.parsePage(paramsToParse);
    }

    public void updateMainLog(String event) {
        mainLog.info((Object)event);
    }

    public String getHtmlDocumentData(int meta_id) {
        String htmlStr = null;
        if (7 == this.getDocType(meta_id)) {
            String sqlStr = "select frame_set from frameset_docs where meta_id = ?";
            Object[] parameters = new String[]{"" + meta_id};
            htmlStr = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.SINGLE_STRING_HANDLER));
        }
        return htmlStr;
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    public TemplateMapper getTemplateMapper() {
        return this.templateMapper;
    }

    public SMTP getSMTP() {
        return new SMTP(this.config.getSmtpServer(), this.config.getSmtpPort());
    }

    public ImcmsAuthenticatorAndUserAndRoleMapper getImcmsAuthenticatorAndUserAndRoleMapper() {
        return this.imcmsAuthenticatorAndUserAndRoleMapper;
    }

    public String getAdminTemplate(String adminTemplateName, UserDomainObject user, List tagsWithReplacements) {
        return this.getTemplateFromDirectory(adminTemplateName, user, tagsWithReplacements, "admin");
    }

    public String getTemplateFromDirectory(String adminTemplateName, UserDomainObject user, List variables, String directory) {
        if (null == user) {
            throw new NullArgumentException("user");
        }
        String langPrefix = user.getLanguageIso639_2();
        return this.getTemplate(langPrefix + "/" + directory + "/" + adminTemplateName, user, variables);
    }

    private String getTemplate(String path, UserDomainObject user, List variables) {
        try {
            VelocityEngine velocity = this.getVelocityEngine(user);
            VelocityContext context = this.getVelocityContext(user);
            if (null != variables) {
                ArrayList<String> parseDocVariables = new ArrayList<String>(variables.size());
                Iterator iterator = variables.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    Object value = iterator.next();
                    context.put(key, value);
                    boolean isVelocityVariable = StringUtils.isAlpha((String)key) || !(value instanceof String);
                    if (isVelocityVariable) continue;
                    parseDocVariables.add(key);
                    parseDocVariables.add((String)value);
                }
                variables = parseDocVariables;
            }
            StringWriter stringWriter = new StringWriter();
            velocity.mergeTemplate(path, "windows-1252", (Context)context, (Writer)stringWriter);
            String result = stringWriter.toString();
            if (null != variables) {
                result = Parser.parseDoc(result, variables.toArray(new String[variables.size()]));
            }
            return result;
        }
        catch (Exception e) {
            throw new UnhandledException("getTemplate(\"" + path + "\") : " + e.getMessage(), (Throwable)e);
        }
    }

    private synchronized VelocityEngine createVelocityEngine(String languageIso639_2) throws Exception {
        VelocityEngine velocity = new VelocityEngine();
        velocity.setProperty("file.resource.loader.path", (Object)this.config.getTemplatePath().getCanonicalPath());
        velocity.setProperty("velocimacro.library", (Object)(languageIso639_2 + "/gui.vm"));
        velocity.setProperty("velocimacro.library.autoreload", (Object)"true");
        velocity.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.SimpleLog4JLogSystem");
        velocity.setProperty("runtime.log.logsystem.log4j.category", (Object)"org.apache.velocity");
        velocity.init();
        return velocity;
    }

    public VelocityEngine getVelocityEngine(UserDomainObject user) {
        try {
            String languageIso639_2 = user.getLanguageIso639_2();
            VelocityEngine velocityEngine = (VelocityEngine)this.velocityEngines.get(languageIso639_2);
            if (velocityEngine == null) {
                velocityEngine = this.createVelocityEngine(languageIso639_2);
                this.velocityEngines.put(languageIso639_2, velocityEngine);
            }
            return velocityEngine;
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public VelocityContext getVelocityContext(UserDomainObject user) {
        VelocityContext context = new VelocityContext();
        context.put("contextPath", (Object)user.getCurrentContextPath());
        context.put("language", (Object)user.getLanguageIso639_2());
        return context;
    }

    public Config getConfig() {
        return this.config;
    }

    public File getRealContextPath() {
        return WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath();
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public synchronized void setSessionCounter(int value) {
        this.setSessionCounterInDb(value);
        this.sessionCounter = this.getSessionCounterFromDb();
    }

    private void setSessionCounterInDb(int value) {
        Object[] parameters = new String[]{"" + value};
        this.getProcedureExecutor().executeUpdateProcedure("SetSessionCounterValue", parameters);
    }

    public void setSessionCounterDate(Date date) {
        this.setSessionCounterDateInDb(date);
        this.sessionCounterDate = this.getSessionCounterDateFromDb();
    }

    private void setSessionCounterDateInDb(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object[] parameters = new String[]{dateFormat.format(date)};
        this.getProcedureExecutor().executeUpdateProcedure("SetSessionCounterDate", parameters);
    }

    public Date getSessionCounterDate() {
        return this.sessionCounterDate;
    }

    public int getDocType(int meta_id) {
        DocumentDomainObject document = this.documentMapper.getDocument(meta_id);
        if (null != document) {
            return document.getDocumentTypeId();
        }
        return 0;
    }

    private SystemData getSystemDataFromDb() {
        SystemData sd = new SystemData();
        Object[] parameters5 = new String[]{};
        String startDocument = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 0", parameters5, Utility.SINGLE_STRING_HANDLER));
        sd.setStartDocument(startDocument == null ? 1001 : Integer.parseInt(startDocument));
        Object[] parameters4 = new String[]{};
        String systemMessage = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 3", parameters4, Utility.SINGLE_STRING_HANDLER));
        sd.setSystemMessage(systemMessage);
        Object[] parameters3 = new String[]{};
        String serverMasterName = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 4", parameters3, Utility.SINGLE_STRING_HANDLER));
        sd.setServerMaster(serverMasterName);
        Object[] parameters2 = new String[]{};
        String serverMasterAddress = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 5", parameters2, Utility.SINGLE_STRING_HANDLER));
        sd.setServerMasterAddress(serverMasterAddress);
        Object[] parameters1 = new String[]{};
        String webMasterName = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 6", parameters1, Utility.SINGLE_STRING_HANDLER));
        sd.setWebMaster(webMasterName);
        Object[] parameters = new String[]{};
        String webMasterAddress = (String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT value FROM sys_data WHERE type_id = 7", parameters, Utility.SINGLE_STRING_HANDLER));
        sd.setWebMasterAddress(webMasterAddress);
        return sd;
    }

    public SystemData getSystemData() {
        return this.sysData;
    }

    public void setSystemData(SystemData sd) {
        Object[] sqlParams = new String[]{"" + sd.getStartDocument()};
        this.getProcedureExecutor().executeUpdateProcedure("StartDocSet", sqlParams);
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand("UPDATE sys_data SET value = ? WHERE type_id = 4", new Object[]{sd.getServerMaster()}));
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand("UPDATE sys_data SET value = ? WHERE type_id = 5", new Object[]{sd.getServerMasterAddress()}));
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand("UPDATE sys_data SET value = ? WHERE type_id = 6", new Object[]{sd.getWebMaster()}));
        this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand("UPDATE sys_data SET value = ? WHERE type_id = 7", new Object[]{sd.getWebMasterAddress()}));
        sqlParams = new String[]{sd.getSystemMessage()};
        this.getProcedureExecutor().executeUpdateProcedure("SystemMessageSet", sqlParams);
        this.sysData = sd;
    }

    public String[][] getAllDocumentTypes(String langPrefixStr) {
        Object[] parameters = new String[]{langPrefixStr};
        return (String[][])this.getProcedureExecutor().executeProcedure("GetDocTypes", parameters, new StringArrayArrayResultSetHandler());
    }

    public Properties getLanguageProperties(UserDomainObject user) {
        String languageIso639_2 = user.getLanguageIso639_2();
        Properties languageProperties = (Properties)this.languagePropertiesMap.get(languageIso639_2);
        if (null == languageProperties) {
            String propertiesFilename = languageIso639_2 + ".properties";
            try {
                languageProperties = Prefs.getProperties(propertiesFilename);
                this.languagePropertiesMap.put(languageIso639_2, languageProperties);
            }
            catch (IOException e) {
                log.fatal((Object)("Failed to read language properties from " + propertiesFilename), (Throwable)e);
                throw new UnhandledException((Throwable)e);
            }
        }
        return languageProperties;
    }

    public File getIncludePath() {
        return this.config.getIncludePath();
    }

    public Collator getDefaultLanguageCollator() {
        try {
            return Collator.getInstance(new Locale(LanguageMapper.convert639_2to639_1(this.config.getDefaultLanguage())));
        }
        catch (LanguageMapper.LanguageNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public CategoryMapper getCategoryMapper() {
        return this.documentMapper.getCategoryMapper();
    }

    public LanguageMapper getLanguageMapper() {
        return this.languageMapper;
    }

    public CachingFileLoader getFileCache() {
        return this.fileLoader;
    }

    public RoleGetter getRoleGetter() {
        return this.imcmsAuthenticatorAndUserAndRoleMapper;
    }

    public ProcedureExecutor getProcedureExecutor() {
        return this.procedureExecutor;
    }

    static {
        mainLog.info((Object)"Main log started.");
    }

    private static class WebappRelativeFileConverter
    implements Converter {
        private WebappRelativeFileConverter() {
        }

        public Object convert(Class type, Object value) {
            return FileUtility.getFileFromWebappRelativePath((String)value);
        }
    }
}

