/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test.external;

import imcode.util.net.SMTP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.activation.DataSource;
import junit.framework.TestCase;

public class TestSMTP
extends TestCase {
    private String fromAddress;
    private String toAddress;
    private static final String TEST_MAIL = "Testing swedish characters: \u00c5\u00c4\u00d6\nThere should be an empty line below\n\nThere should be a single dot below\n.\n";
    private SMTP smtp;
    private static final String TEST_SUBJECT = "JUnit-testing SMTP.java";

    public void setUp() throws Exception {
        super.setUp();
        Properties smtpProperties = new Properties();
        smtpProperties.load(new FileInputStream(System.getProperty("test.smtp.properties", "build.properties")));
        String smtpServer = smtpProperties.getProperty("smtp-server");
        this.fromAddress = smtpProperties.getProperty("servermaster-email");
        this.toAddress = smtpProperties.getProperty("servermaster-email");
        this.smtp = new SMTP(smtpServer, 25);
    }

    public void testSendMail() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress, new String[]{this.toAddress}, TEST_SUBJECT, TEST_MAIL);
        this.smtp.sendMail(mail);
    }

    public void testSendMailBcc() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress);
        mail.setSubject("BCC JUnit-testing SMTP.java");
        mail.setBody(TEST_MAIL);
        mail.setBccAddresses(new String[]{this.toAddress});
        mail.setToAddresses(new String[]{"imCMS:;"});
        this.smtp.sendMail(mail);
    }

    public void testSendGroupMail() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress);
        mail.setSubject("Group JUnit-testing SMTP.java");
        mail.setBody(TEST_MAIL);
        mail.setToAddresses(new String[]{"imCMS Group: <" + this.toAddress + "> ;"});
        this.smtp.sendMail(mail);
    }

    public void testSendBccGroupMail() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress);
        mail.setSubject("BCC Group JUnit-testing SMTP.java");
        mail.setBody(TEST_MAIL);
        mail.setBccAddresses(new String[]{this.toAddress});
        mail.setToAddresses(new String[]{"imCMS Group:;"});
        this.smtp.sendMail(mail);
    }

    public void testAttachment() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress, new String[]{this.toAddress}, "Attachment JUnit-testing SMTP.java", TEST_MAIL);
        DataSource dataSource = new DataSource(){

            public String getContentType() {
                return "text/plain";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                OutputStreamWriter writer = new OutputStreamWriter(os);
                writer.write("Testing attachment!");
                ((Writer)writer).flush();
                return new ByteArrayInputStream(os.toByteArray());
            }

            public String getName() {
                return "Test";
            }

            public OutputStream getOutputStream() {
                return null;
            }
        };
        DataSource[] dataSources = new DataSource[]{dataSource};
        mail.setAttachments(dataSources);
        this.smtp.sendMail(mail);
    }

    public void testHtml() throws IOException {
        SMTP.Mail mail = new SMTP.Mail(this.fromAddress);
        mail.setSubject("HTML JUnit-testing SMTP.java");
        mail.setToAddresses(new String[]{this.toAddress});
        mail.setHtmlBody("<html><body>This mail should have an <strong>HTML</strong> <em>alternative</em> and these swedish characters should be OK: \u00c5\u00c4\u00d6.</body></html>");
        this.smtp.sendMail(mail);
    }
}

