/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.PatternMatcherInput;

public class LinkCheck
extends HttpServlet {
    private static final String USER_AGENT = "imCMS LinkCheck - http://www.imcms.net/";
    private static final String HTTP_REQUEST_HEADER__USER_AGENT = "user-agent";
    private static final int CONNECTION_TIMEOUT_MILLISECONDS = 10000;
    private static final int READ_TIMEOUT_MILLISECONDS = 10000;
    private static final Logger log = Logger.getLogger((String)LinkCheck.class.getName());
    public static final String REQUEST_PARAMETER__START_BUTTON = "start_check";
    public static final String REQUEST_PARAMETER__BROKEN_ONLY = "broken_only";
    public static final String REQUEST_PARAMETER__START_ID = "start_id";
    public static final String REQUEST_PARAMETER__END_ID = "end_id";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            Utility.forwardToLogin(request, response);
            return;
        }
        ArrayList links = new ArrayList();
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentIndex reindexingIndex = documentMapper.getDocumentIndex();
        int lowestDocumentId = documentMapper.getLowestDocumentId();
        int highestDocumentId = documentMapper.getHighestDocumentId();
        int startId = NumberUtils.stringToInt((String)request.getParameter(REQUEST_PARAMETER__START_ID), (int)lowestDocumentId);
        int endId = NumberUtils.stringToInt((String)request.getParameter(REQUEST_PARAMETER__END_ID), (int)highestDocumentId);
        IntRange range = new IntRange(startId, endId);
        range = new IntRange(Math.max(range.getMinimumInteger(), lowestDocumentId), Math.min(range.getMaximumInteger(), highestDocumentId));
        this.addUrlDocumentLinks(links, reindexingIndex, user, request, range);
        this.addTextAndImageLinks(links, reindexingIndex, user, request, range);
        Collections.sort(links, new Comparator(){

            public int compare(Object o1, Object o2) {
                Link l1 = (Link)o1;
                Link l2 = (Link)o2;
                return l1.getDocument().getId() - l2.getDocument().getId();
            }
        });
        LinkCheckPage linkCheckPage = new LinkCheckPage();
        linkCheckPage.setLinksIterator(links.iterator());
        boolean doCheckLinks = null != request.getParameter(REQUEST_PARAMETER__START_BUTTON);
        linkCheckPage.setDoCheckLinks(doCheckLinks);
        linkCheckPage.setStartId(range.getMinimumInteger());
        linkCheckPage.setEndId(range.getMaximumInteger());
        linkCheckPage.setBrokenOnly(null != request.getParameter(REQUEST_PARAMETER__BROKEN_ONLY));
        if (doCheckLinks) {
            Iterator iterator = links.iterator();
            for (int i = 0; i < 10; ++i) {
                new LinkCheckThread(iterator).start();
            }
        }
        linkCheckPage.forward(request, response, user);
    }

    private void addUrlDocumentLinks(List links, DocumentIndex reindexingIndex, UserDomainObject user, HttpServletRequest request, IntRange range) {
        TermQuery urlDocumentsQuery = new TermQuery(new Term("doc_type_id", "5"));
        List urlDocuments = reindexingIndex.search((Query)urlDocumentsQuery, null, user);
        Iterator iterator = urlDocuments.iterator();
        while (iterator.hasNext()) {
            UrlDocumentDomainObject urlDocument = (UrlDocumentDomainObject)iterator.next();
            if (!range.containsInteger(urlDocument.getId())) continue;
            UrlDocumentLink link = new UrlDocumentLink(urlDocument, request);
            links.add(link);
        }
    }

    private void addTextAndImageLinks(List links, DocumentIndex reindexingIndex, UserDomainObject user, HttpServletRequest request, IntRange range) {
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new PrefixQuery(new Term("nonstripped_text", "http")), false, false);
        query.add((Query)new PrefixQuery(new Term("nonstripped_text", "href")), false, false);
        query.add((Query)new PrefixQuery(new Term("image_link_url", "http")), false, false);
        List textDocuments = reindexingIndex.search((Query)query, null, user);
        Iterator iterator = textDocuments.iterator();
        while (iterator.hasNext()) {
            TextDocumentDomainObject textDocument = (TextDocumentDomainObject)iterator.next();
            if (!range.containsInteger(textDocument.getId())) continue;
            this.addTextLinks(links, textDocument, request);
            this.addImageLinks(links, textDocument, request);
        }
    }

    private void addTextLinks(List links, TextDocumentDomainObject textDocument, HttpServletRequest request) {
        Map texts = textDocument.getTexts();
        Iterator iterator = texts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer textIndex = (Integer)entry.getKey();
            TextDomainObject text = (TextDomainObject)entry.getValue();
            String textString = text.getText();
            Perl5Util perl5Util = new Perl5Util();
            PatternMatcherInput patternMatcherInput = new PatternMatcherInput(textString);
            while (this.matchesUrl(perl5Util, patternMatcherInput)) {
                String url = perl5Util.group(1);
                if (null == url) {
                    url = perl5Util.group(0);
                }
                TextLink link = new TextLink(textDocument, textIndex, url, request);
                links.add(link);
            }
        }
    }

    boolean matchesUrl(Perl5Util perl5Util, PatternMatcherInput patternMatcherInput) {
        String urlWithoutSchemePattern = "[^\\s\"'()]+";
        return perl5Util.match("m,\\bhttp://" + urlWithoutSchemePattern + "|\\bhref=[\"']?(" + urlWithoutSchemePattern + "),i", patternMatcherInput);
    }

    private void addImageLinks(List links, TextDocumentDomainObject textDocument, HttpServletRequest request) {
        Map images = textDocument.getImages();
        Iterator iterator = images.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer imageIndex = (Integer)entry.getKey();
            ImageDomainObject image = (ImageDomainObject)entry.getValue();
            String imageLinkUrl = image.getLinkUrl();
            if (null == imageLinkUrl || imageLinkUrl.length() <= 0) continue;
            ImageLink link = new ImageLink(textDocument, imageIndex, imageLinkUrl, request);
            links.add(link);
        }
    }

    public static class ImageLink
    extends TextDocumentElementLink {
        public ImageLink(TextDocumentDomainObject textDocument, int index, String url, HttpServletRequest request) {
            super(textDocument, index, url, request);
        }
    }

    public static class TextLink
    extends TextDocumentElementLink {
        public TextLink(TextDocumentDomainObject textDocument, int index, String url, HttpServletRequest request) {
            super(textDocument, index, url, request);
        }
    }

    public static abstract class TextDocumentElementLink
    extends Link {
        protected TextDocumentDomainObject textDocument;
        protected int index;
        protected String url;

        public TextDocumentElementLink(TextDocumentDomainObject textDocument, int index, String url, HttpServletRequest request) {
            super(request);
            this.textDocument = textDocument;
            this.index = index;
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public int getIndex() {
            return this.index;
        }

        public DocumentDomainObject getDocument() {
            return this.textDocument;
        }
    }

    public static final class UrlDocumentLink
    extends Link {
        private UrlDocumentDomainObject urlDocument;
        private DocumentMapper.TextDocumentMenuIndexPair[] documentMenuPairsContainingUrlDocument;

        public UrlDocumentLink(UrlDocumentDomainObject urlDocument, HttpServletRequest request) {
            super(request);
            this.urlDocument = urlDocument;
            this.documentMenuPairsContainingUrlDocument = Imcms.getServices().getDocumentMapper().getDocumentMenuPairsContainingDocument(urlDocument);
        }

        public String getUrl() {
            return this.urlDocument.getUrl();
        }

        public DocumentDomainObject getDocument() {
            return this.urlDocument;
        }

        public DocumentMapper.TextDocumentMenuIndexPair[] getDocumentMenuPairsContainingUrlDocument() {
            return this.documentMenuPairsContainingUrlDocument;
        }
    }

    public static abstract class Link {
        private boolean checkable = true;
        private boolean ok;
        private boolean hostFound;
        private boolean hostReachable;
        private boolean checked;
        private HttpServletRequest request;

        public Link(HttpServletRequest request) {
            this.request = request;
        }

        public abstract String getUrl();

        public boolean isCheckable() {
            this.check();
            return this.checkable;
        }

        public boolean isHostFound() {
            this.check();
            return this.hostFound;
        }

        public boolean isHostReachable() {
            this.check();
            return this.hostReachable;
        }

        public boolean isOk() {
            this.check();
            return this.ok;
        }

        private synchronized void check() {
            if (this.checked) {
                return;
            }
            this.checked = true;
            this.checkUrl(this.fixSchemeLessUrl());
        }

        public String fixSchemeLessUrl() {
            String url = this.getUrl();
            boolean hasScheme = Pattern.compile("^(\\w+):").matcher(url).find();
            if (!hasScheme) {
                String requestUrlWithoutPath = Utility.getRequestURLWithoutPath(this.request);
                url = url.startsWith("/") ? requestUrlWithoutPath + url : requestUrlWithoutPath + this.request.getContextPath() + "/" + url;
            }
            return url;
        }

        private void checkUrl(String url) {
            HeadMethod httpMethod;
            log.debug((Object)("checkUrl(" + url + ")"));
            HttpClient httpClient = new HttpClient();
            httpClient.setConnectionTimeout(10000);
            httpClient.setTimeout(10000);
            try {
                httpMethod = new HeadMethod(url);
            }
            catch (Exception e) {
                this.checkable = false;
                return;
            }
            httpMethod.setRequestHeader(LinkCheck.HTTP_REQUEST_HEADER__USER_AGENT, LinkCheck.USER_AGENT);
            try {
                int status = httpClient.executeMethod((HttpMethod)httpMethod);
                this.hostFound = true;
                this.hostReachable = true;
                httpMethod.releaseConnection();
                if (200 == status) {
                    this.ok = true;
                }
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("Error testing url " + url), (Throwable)e);
            }
            catch (UnknownHostException e) {
            }
            catch (HttpConnection.ConnectionTimeoutException e) {
                this.hostFound = true;
            }
            catch (ConnectException e) {
                this.hostFound = true;
            }
            catch (HttpException e) {
                this.hostFound = true;
                this.hostReachable = true;
            }
            catch (IOException e) {
                log.warn((Object)"Unknown IOException in LinkCheck.", (Throwable)e);
            }
        }

        public abstract DocumentDomainObject getDocument();
    }

    public static class LinkCheckPage
    implements Serializable {
        public static final String REQUEST_ATTRIBUTE__PAGE = "linkpage";
        boolean brokenOnly;
        boolean doCheckLinks;
        private Iterator linksIterator;
        private int startId;
        private int endId;

        public void forward(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException, ServletException {
            this.putInRequest(request);
            String forwardPath = "/imcms/" + user.getLanguageIso639_2() + "/jsp/linkcheck/linkcheck.jsp";
            request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        }

        public void putInRequest(HttpServletRequest request) {
            request.setAttribute(REQUEST_ATTRIBUTE__PAGE, (Object)this);
        }

        public boolean isDoCheckLinks() {
            return this.doCheckLinks;
        }

        public void setDoCheckLinks(boolean doCheckLinks) {
            this.doCheckLinks = doCheckLinks;
        }

        public boolean isBrokenOnly() {
            return this.brokenOnly;
        }

        public void setBrokenOnly(boolean brokenOnly) {
            this.brokenOnly = brokenOnly;
        }

        public void setLinksIterator(Iterator linksIterator) {
            this.linksIterator = linksIterator;
        }

        public Iterator getLinksIterator() {
            return this.linksIterator;
        }

        public int getStartId() {
            return this.startId;
        }

        public int getEndId() {
            return this.endId;
        }

        public void setStartId(int startId) {
            this.startId = startId;
        }

        public void setEndId(int endId) {
            this.endId = endId;
        }
    }

    public static class LinkCheckThread
    extends Thread {
        private Iterator iterator;

        public LinkCheckThread(Iterator iterator) {
            this.iterator = iterator;
        }

        public void run() {
            while (this.iterator.hasNext()) {
                try {
                    Link link = (Link)this.iterator.next();
                    link.check();
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
        }
    }
}

