/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.mock.MockDatabase;
import com.imcode.db.mock.MockResultSet;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaver;
import com.imcode.imcms.mapping.MockDocumentIndex;
import imcode.server.MockImcmsServices;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.NoPermissionToCreateDocumentException;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.IntegerSet;
import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;

public class TestDocumentMapper
extends TestCase {
    private DocumentMapper documentMapper;
    private MockDatabase database;
    private UserDomainObject user;
    private RoleDomainObject testRole;
    private RoleId userRole;
    private TextDocumentDomainObject textDocument;
    private TextDocumentDomainObject oldDocument;
    private MockDocumentIndex documentIndex;
    private static final Integer ONE = new Integer(1);

    protected void setUp() throws Exception {
        BasicConfigurator.configure((Appender)new NullAppender());
        super.setUp();
        this.user = new UserDomainObject(0);
        this.userRole = new RoleId(3);
        this.user.addRoleId(this.userRole);
        this.testRole = new RoleDomainObject(new RoleId(2), "Testrole", 0);
        this.oldDocument = this.createTextDocument(1001);
        this.textDocument = this.createTextDocument(1002);
        this.database = new MockDatabase();
        MockImcmsServices mockImcmsServices = new MockImcmsServices();
        mockImcmsServices.setDatabase((Database)this.database);
        ImcmsAuthenticatorAndUserAndRoleMapper userRegistry = new ImcmsAuthenticatorAndUserAndRoleMapper(mockImcmsServices){

            public UserDomainObject getUser(int userId) {
                return TestDocumentMapper.this.user;
            }
        };
        MockImcmsServices services = new MockImcmsServices();
        services.setImcmsAuthenticatorAndUserAndRoleMapper(userRegistry);
        services.setTemplateMapper(new TemplateMapper(new MockImcmsServices()){

            public TemplateDomainObject getTemplateById(int template_id) {
                return null;
            }
        });
        this.documentIndex = new MockDocumentIndex();
        CategoryMapper categoryMapper = new CategoryMapper((Database)this.database);
        this.documentMapper = new DocumentMapper(services, (Database)this.database);
        this.documentMapper.setDocumentIndex(this.documentIndex);
        services.setDocumentMapper(this.documentMapper);
        services.setCategoryMapper(categoryMapper);
    }

    private TextDocumentDomainObject createTextDocument(int documentId) {
        TextDocumentDomainObject newTextDocument = new TextDocumentDomainObject();
        newTextDocument.setId(documentId);
        return newTextDocument;
    }

    public void testNotSerializable() {
        if (DocumentMapper.class.isAssignableFrom(Serializable.class)) {
            TestDocumentMapper.fail((String)"DocumentMapper must not be serializable so it can't be put in the session.");
        }
    }

    public void testUpdateDocumentRolePermissionsWithNoPermissions() throws Exception {
        this.textDocument.setDocumentPermissionSetTypeForRoleId(this.testRole.getId(), DocumentPermissionSetTypeDomainObject.READ);
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)0, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsWithRestricted1Permission() throws Exception {
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.RESTRICTED_1);
        this.textDocument.setRoleIdsMappedToDocumentPermissionSetTypes(this.oldDocument.getRoleIdsMappedToDocumentPermissionSetTypes());
        this.textDocument.setDocumentPermissionSetTypeForRoleId(this.testRole.getId(), DocumentPermissionSetTypeDomainObject.READ);
        DocumentPermissionSetDomainObject permissionSetForRestrictedOne = new DocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.RESTRICTED_1){

            public void setFromBits(int permissionBits) {
            }
        };
        this.oldDocument.getPermissionSets().setRestricted1(permissionSetForRestrictedOne);
        permissionSetForRestrictedOne.setEditPermissions(false);
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)0, (int)this.database.getSqlCallCount());
        permissionSetForRestrictedOne.setEditPermissions(true);
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)4, (int)this.database.getSqlCallCount());
        this.textDocument.setDocumentPermissionSetTypeForRoleId(this.testRole.getId(), DocumentPermissionSetTypeDomainObject.RESTRICTED_1);
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("INSERT INTO roles_rights (role_id, meta_id, set_id) VALUES(?,?,?)"));
    }

    public void testUpdateDocumentRolePermissionsWithFullPermission() throws Exception {
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.textDocument.setDocumentPermissionSetTypeForRoleId(this.testRole.getId(), DocumentPermissionSetTypeDomainObject.READ);
        this.textDocument.setRoleIdsMappedToDocumentPermissionSetTypes(this.oldDocument.getRoleIdsMappedToDocumentPermissionSetTypes());
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)2, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsRemovesPermission() {
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("DELETE FROM roles_rights WHERE role_id = ? AND meta_id = ?"));
        this.database.assertNotCalled((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsWithParametersSqlCallPredicate("INSERT INTO roles_rights (role_id, meta_id, set_id) VALUES(?,?,?)", new String[]{"" + this.userRole.intValue(), "" + this.textDocument.getId(), "" + DocumentPermissionSetTypeDomainObject.FULL}));
        this.database.assertNotCalled((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsWithParametersSqlCallPredicate("INSERT INTO roles_rights (role_id, meta_id, set_id) VALUES(?,?,?)", new String[]{"" + this.userRole.intValue(), "" + this.textDocument.getId(), "" + DocumentPermissionSetTypeDomainObject.NONE}));
        TestDocumentMapper.assertEquals((int)1, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsAllowsNullOldDocument() throws Exception {
        this.documentMapper.getDocumentSaver().updateDocumentRolePermissions(this.textDocument, this.user, null);
        TestDocumentMapper.assertTrue((boolean)true);
    }

    public void testSaveNewBrowserDocument() throws Exception {
        BrowserDocumentDomainObject browserDocument = new BrowserDocumentDomainObject();
        browserDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.FULL);
        browserDocument.setBrowserDocumentId(BrowserDocumentDomainObject.Browser.DEFAULT, 1001);
        browserDocument.setCreator(new UserDomainObject(0));
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("meta"), (Object)new Integer(1002));
        this.documentMapper.saveNewDocument(browserDocument, this.user);
        this.database.assertExpectedSqlCalls();
        this.database.assertCallCount(1, (MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("browser_docs"));
        TestDocumentMapper.assertEquals((int)1002, (int)browserDocument.getId());
    }

    public void testDeleteDocument() {
        Object[][] documentResultRows = new Object[1][19];
        documentResultRows[0][0] = new Integer(this.textDocument.getId());
        documentResultRows[0][1] = new Integer(this.textDocument.getDocumentTypeId());
        documentResultRows[0][5] = new Integer(this.user.getId());
        documentResultRows[0][16] = new Integer(DocumentSaver.convertPublicationStatusToInt(this.textDocument.getPublicationStatus()));
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.StartsWithSqlCallPredicate("SELECT meta_id,\ndoc_type,\nmeta_headline,\nmeta_text,\nmeta_image,\nowner_id,\npermissions,\nshared,\nshow_meta,\nlang_prefix,\ndate_created,\ndate_modified,\ndisable_search,\ntarget,\narchived_datetime,\npublisher_id,\nstatus,\npublication_start_datetime,\npublication_end_datetime\nFROM meta\nWHERE meta_id "), (Object)new MockResultSet(documentResultRows));
        MockResultSet textDocsResultRow = new MockResultSet((Object[][])new Object[][]{{ONE, ONE, ONE, ONE, ONE}});
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("FROM text_docs"), (Object)textDocsResultRow);
        DocumentDomainObject document = this.documentMapper.getDocument(this.textDocument.getId());
        TestDocumentMapper.assertNotNull((Object)document);
        this.documentMapper.deleteDocument(this.textDocument, this.user);
        this.database.assertCalledInOrder(new MockDatabase.SqlCallPredicate[]{new MockDatabase.DeleteFromTableSqlCallPredicate("text_docs"), new MockDatabase.DeleteFromTableSqlCallPredicate("meta")});
        this.database.assertCalledInOrder(new MockDatabase.SqlCallPredicate[]{new MockDatabase.DeleteFromTableSqlCallPredicate("texts"), new MockDatabase.DeleteFromTableSqlCallPredicate("meta")});
        this.database.assertCalledInOrder(new MockDatabase.SqlCallPredicate[]{new MockDatabase.DeleteFromTableSqlCallPredicate("childs"), new MockDatabase.DeleteFromTableSqlCallPredicate("childs"), new MockDatabase.DeleteFromTableSqlCallPredicate("menus"), new MockDatabase.DeleteFromTableSqlCallPredicate("meta")});
        TestDocumentMapper.assertTrue((boolean)this.documentIndex.isRemoveDocumentCalled());
        TestDocumentMapper.assertFalse((boolean)this.documentIndex.isIndexDocumentCalled());
    }

    public void testCreateTextDocument() throws NoPermissionToAddDocumentToMenuException, NoPermissionToCreateDocumentException {
        this.user.addRoleId(RoleId.SUPERADMIN);
        TextDocumentDomainObject document = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.textDocument, this.user);
        document.setTemplateId(1);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("meta"), (Object)new Integer(1002));
        this.documentMapper.saveNewDocument(document, this.user);
        this.database.assertExpectedSqlCalls();
    }

    public void testCreateHtmlDocument() throws NoPermissionToAddDocumentToMenuException, NoPermissionToCreateDocumentException {
        this.user.addRoleId(RoleId.SUPERADMIN);
        DocumentDomainObject document = this.documentMapper.createDocumentOfTypeFromParent(7, this.textDocument, this.user);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("meta"), (Object)new Integer(1002));
        this.documentMapper.saveNewDocument(document, this.user);
        this.database.assertExpectedSqlCalls();
    }

    public void testCreateUrlDocument() throws NoPermissionToAddDocumentToMenuException, NoPermissionToCreateDocumentException {
        this.user.addRoleId(RoleId.SUPERADMIN);
        DocumentDomainObject document = this.documentMapper.createDocumentOfTypeFromParent(5, this.textDocument, this.user);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableSqlCallPredicate("meta"), (Object)new Integer(1002));
        this.documentMapper.saveNewDocument(document, this.user);
        this.database.assertExpectedSqlCalls();
    }

    public void testSetTemplateForNewTextDocument() throws Exception {
        Integer templateId1 = new Integer(1);
        Integer templateId2 = new Integer(2);
        Integer templateId3 = new Integer(3);
        Integer templateId4 = new Integer(4);
        this.oldDocument.setTemplateId(templateId1);
        this.oldDocument.setDefaultTemplateIdForRestricted1(templateId3);
        TextDocumentPermissionSetDomainObject permissionSetForR1 = (TextDocumentPermissionSetDomainObject)this.oldDocument.getPermissionSets().getRestricted1();
        permissionSetForR1.setAllowedDocumentTypeIds(new IntegerSet(2));
        this.oldDocument.setDefaultTemplateIdForRestricted2(templateId4);
        TextDocumentPermissionSetDomainObject permissionSetForR2 = (TextDocumentPermissionSetDomainObject)this.oldDocument.getPermissionSets().getRestricted2();
        permissionSetForR2.setAllowedDocumentTypeIds(new IntegerSet(2));
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.FULL);
        TextDocumentDomainObject newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)this.oldDocument.getTemplateId(), (int)newDocument.getTemplateId());
        TestDocumentMapper.assertEquals((int)templateId1, (int)newDocument.getTemplateId());
        this.oldDocument.setDefaultTemplateId(templateId2);
        newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)templateId2, (int)newDocument.getTemplateId());
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.RESTRICTED_1);
        newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)templateId3, (int)newDocument.getTemplateId());
        this.oldDocument.setDefaultTemplateIdForRestricted1(null);
        newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)templateId2, (int)newDocument.getTemplateId());
        this.oldDocument.setDocumentPermissionSetTypeForRoleId(this.userRole, DocumentPermissionSetTypeDomainObject.RESTRICTED_2);
        newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)templateId4, (int)newDocument.getTemplateId());
        this.oldDocument.setDefaultTemplateIdForRestricted2(null);
        newDocument = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.oldDocument, this.user);
        TestDocumentMapper.assertEquals((int)templateId2, (int)newDocument.getTemplateId());
    }
}

