/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.db;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.imcms.db.ProcedureExecutor;
import imcode.util.CachingFileLoader;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class DefaultProcedureExecutor
implements ProcedureExecutor {
    private final Database database;
    private CachingFileLoader fileLoader = new CachingFileLoader();
    private Map procedureCache = new HashMap();
    private static final Logger log = Logger.getLogger((String)DefaultProcedureExecutor.class.getName());

    public DefaultProcedureExecutor(Database database) {
        this.database = database;
    }

    public int executeUpdateProcedure(String procedureName, Object[] parameters) throws DatabaseException {
        Procedure procedure = this.getProcedure(procedureName);
        Object[] parametersAtCorrectIndices = this.getParametersAtCorrectIndicesForProcedure(procedure, parameters);
        String body = procedure.getBody();
        this.logProcedureCall(procedureName, body, parametersAtCorrectIndices);
        return (Integer)this.database.execute((DatabaseCommand)new SqlUpdateDatabaseCommand(body, parametersAtCorrectIndices));
    }

    private void logProcedureCall(String procedureName, String body, Object[] parametersAtCorrectIndices) {
        log.trace((Object)("Calling procedure " + procedureName + " with parameters " + ArrayUtils.toString((Object)parametersAtCorrectIndices) + " and body " + body));
    }

    public Object executeProcedure(String procedureName, Object[] params, ResultSetHandler resultSetHandler) {
        Procedure procedure = this.getProcedure(procedureName);
        Object[] parametersAtCorrectIndices = this.getParametersAtCorrectIndicesForProcedure(procedure, params);
        String body = procedure.getBody();
        this.logProcedureCall(procedureName, body, parametersAtCorrectIndices);
        return this.database.execute((DatabaseCommand)new SqlQueryCommand(body, parametersAtCorrectIndices, resultSetHandler));
    }

    private Object[] getParametersAtCorrectIndicesForProcedure(Procedure procedure, Object[] parameters) {
        int[] parameterIndices = procedure.getParameterIndices();
        Object[] parametersAtCorrectIndices = new String[parameterIndices.length];
        for (int i = 0; i < parameterIndices.length; ++i) {
            int parameterIndex = parameterIndices[i];
            parametersAtCorrectIndices[i] = parameters[parameterIndex];
        }
        return parametersAtCorrectIndices;
    }

    private Procedure getProcedure(String wantedProcedure) {
        String procedureName = wantedProcedure.toLowerCase();
        File file = this.getFile(procedureName);
        Procedure procedure = (Procedure)this.procedureCache.get(procedureName);
        String procedureContents = this.fileLoader.getCachedFileStringIfRecent(file);
        if (null == procedureContents) {
            String procedureContents1 = this.loadFile(file);
            log.debug((Object)("Loading procedure " + procedureName));
            procedure = this.prepareProcedure(procedureContents1, procedureName);
            this.procedureCache.put(procedureName, procedure);
        }
        return procedure;
    }

    Procedure prepareProcedure(String procedureContents, String procedureName) {
        Pattern headerPattern = Pattern.compile("CREATE\\s+PROCEDURE\\s+\\S+\\s+(.*)\\bAS\\s+", 34);
        Matcher headerMatcher = headerPattern.matcher(procedureContents);
        if (!headerMatcher.find()) {
            throw new RuntimeException("Failed to parse procedure " + procedureName + ": " + procedureContents);
        }
        String headerParameters = headerMatcher.group(1);
        String body = procedureContents.substring(headerMatcher.end());
        Pattern parameterPattern = Pattern.compile("@(\\w+)");
        Map parameterNameToIndexMap = this.getParameterNameToIndexMapParsedFromHeader(parameterPattern, headerParameters);
        ArrayList parameterIndices = new ArrayList();
        String bodyWithParametersReplaced = this.replaceVariablesInBodyAndAddIndicesToList(parameterPattern, body, parameterNameToIndexMap, parameterIndices, procedureName);
        int[] parameterIndicesArray = ArrayUtils.toPrimitive((Integer[])parameterIndices.toArray(new Integer[parameterIndices.size()]));
        return new Procedure(bodyWithParametersReplaced, parameterIndicesArray);
    }

    private String loadFile(File file) {
        try {
            return this.fileLoader.getCachedFileString(file);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private File getFile(String wantedProcedure) {
        return FileUtility.getFileFromWebappRelativePath("WEB-INF/sql/sprocs/" + wantedProcedure.toLowerCase() + ".prc");
    }

    private Map getParameterNameToIndexMapParsedFromHeader(Pattern parameterPattern, String headerParameters) {
        Matcher parametersMatcher = parameterPattern.matcher(headerParameters);
        HashMap<String, Integer> parameterNameToIndexMap = new HashMap<String, Integer>();
        int headerParametersFound = 0;
        while (parametersMatcher.find()) {
            String parameterName = parametersMatcher.group(1);
            parameterNameToIndexMap.put(parameterName, new Integer(headerParametersFound++));
        }
        return parameterNameToIndexMap;
    }

    private String replaceVariablesInBodyAndAddIndicesToList(Pattern parameterPattern, String body, Map parameterNameToIndexMap, List parameterIndices, String procedureName) {
        Matcher bodyParametersMatcher = parameterPattern.matcher(body);
        StringBuffer bodyStringBuffer = new StringBuffer();
        while (bodyParametersMatcher.find()) {
            bodyParametersMatcher.appendReplacement(bodyStringBuffer, "?");
            String parameterName = bodyParametersMatcher.group(1);
            Integer parameterIndex = (Integer)parameterNameToIndexMap.get(parameterName);
            if (null == parameterIndex) {
                throw new IllegalArgumentException("No parameter @" + parameterName + " in parameter list of procedure " + procedureName);
            }
            parameterIndices.add(parameterIndex);
        }
        bodyParametersMatcher.appendTail(bodyStringBuffer);
        return bodyStringBuffer.toString();
    }

    static class Procedure {
        private String sql;
        private int[] parameterIndices;

        Procedure(String sql, int[] parameterIndices) {
            this.sql = sql;
            this.parameterIndices = parameterIndices;
        }

        public int[] getParameterIndices() {
            return this.parameterIndices;
        }

        public String getBody() {
            return this.sql;
        }
    }
}

