/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.db.Database;
import com.imcode.db.DatabaseException;
import com.imcode.db.mock.MockDatabase;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import com.imcode.imcms.db.ProcedureExecutor;
import imcode.server.LanguageMapper;
import imcode.server.MockImcmsServices;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.MockRoleGetter;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;
import org.apache.commons.dbutils.ResultSetHandler;

public class TestUserService
extends TestCase {
    private UserService userService;
    private MockContentManagementSystem contentManagementSystem;
    private MockDatabase database;
    private UserDomainObject internalUser;
    private static final int HIGHEST_USER_ID = 3;
    private MockImcmsServices mockImcmsServices;

    protected void setUp() throws Exception {
        super.setUp();
        this.contentManagementSystem = new MockContentManagementSystem();
        this.internalUser = new UserDomainObject(3);
        this.contentManagementSystem.setCurrentUser(new User(this.internalUser));
        this.mockImcmsServices = new MockImcmsServices();
        this.database = new MockDatabase();
        this.mockImcmsServices.setDatabase((Database)this.database);
        this.mockImcmsServices.setLanguageMapper(new LanguageMapper((Database)this.database, "eng"));
        this.mockImcmsServices.setProcedureExecutor(new MockProcedureExecutor(this.database));
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper(this.mockImcmsServices);
        this.mockImcmsServices.setImcmsAuthenticatorAndUserAndRoleMapper(imcmsAuthenticatorAndUserAndRoleMapper);
        this.contentManagementSystem.setInternal(this.mockImcmsServices);
        this.mockImcmsServices.setRoleGetter(new MockRoleGetter());
        this.userService = new UserService(this.contentManagementSystem);
    }

    public void testGetUser() throws NoPermissionException {
        TestUserService.assertNull((Object)this.userService.getUser("noone"));
    }

    public void testNewUserCanHaveRoles() throws SaveException, NoPermissionException {
        this.internalUser.addRoleId(RoleId.USERADMIN);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("users", "test"), (Object)new Integer(4));
        User user = this.userService.createNewUser("test", "test");
        user.addRole(new Role(this.mockImcmsServices.getRoleGetter().getRole(RoleId.SUPERADMIN)));
        this.userService.saveUser(user);
        this.database.assertExpectedSqlCalls();
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("role"));
    }

    public void testNonAdminCantCreateUser() throws SaveException {
        User user = this.userService.createNewUser("test", "test");
        user.addRole(new Role(this.mockImcmsServices.getRoleGetter().getRole(RoleId.SUPERADMIN)));
        try {
            this.userService.saveUser(user);
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
        this.database.assertExpectedSqlCalls();
    }

    public void testNonAdminCantEditOtherUsers() throws SaveException {
        UserDomainObject otherInternalUser = new UserDomainObject(4);
        User otherUser = new User(otherInternalUser);
        try {
            this.userService.saveUser(otherUser);
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    public void testUserCanEditSelf() throws SaveException, NoPermissionException {
        String loginName = "loginName";
        String firstName = "firstName";
        this.internalUser.setLoginName(loginName);
        this.internalUser.setFirstName(firstName);
        this.internalUser.setLastName("lastName");
        User user = this.contentManagementSystem.getCurrentUser();
        String newLoginName = "newLoginName";
        String newFirstName = "newFirstName";
        TestUserService.assertEquals((String)loginName, (String)user.getLoginName());
        TestUserService.assertEquals((String)firstName, (String)user.getFirstName());
        user.setLoginName(newLoginName);
        user.setFirstName(newFirstName);
        this.userService.saveUser(user);
        this.database.assertCalled("User can update contents of users table.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", (Object)"3"));
        this.database.assertNotCalled("Old login name set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", (Object)loginName));
        this.database.assertCalled("New login name not set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", (Object)newLoginName));
        this.database.assertNotCalled("Old first name set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", (Object)firstName));
        this.database.assertCalled("New first name not set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", (Object)newFirstName));
        this.database.assertNotCalled("User can not change own roles.", (MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("role"));
        this.internalUser.addRoleId(RoleId.SUPERADMIN);
        this.userService.saveUser(user);
        this.database.assertCalled("Superadmin can change own roles.", (MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("role"));
    }

    public void testCreateNewRole() throws SaveException, NoPermissionException {
        this.internalUser.addRoleId(RoleId.SUPERADMIN);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("INSERT INTO roles (role_name, permissions, admin_role) VALUES(?,?,0)"), (Object)new Integer(3));
        String roleName = "test role";
        Role newRole = this.userService.createNewRole(roleName);
        this.userService.saveRole(newRole);
        this.database.assertExpectedSqlCalls();
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("roles", roleName));
    }

    public void testGetAllRoles() {
        try {
            this.userService.getAllRoles();
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    public void testGetRoleByName() throws NoPermissionException {
        TestUserService.assertNull((Object)this.userService.getRole(""));
    }

    public void testGetRoleById() throws NoPermissionException {
        TestUserService.assertNull((Object)this.userService.getRole(1));
    }

    public static class MockProcedureExecutor
    implements ProcedureExecutor {
        private MockDatabase database;

        public MockProcedureExecutor(MockDatabase database) {
            this.database = database;
        }

        public int executeUpdateProcedure(String procedureName, Object[] parameters) throws DatabaseException {
            return this.database.executeUpdate(procedureName, parameters);
        }

        public Object executeProcedure(String procedureName, Object[] params, ResultSetHandler resultSetHandler) {
            return this.database.executeQuery(procedureName, params, resultSetHandler);
        }
    }
}

