/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.User;

class SecurityChecker {
    private ContentManagementSystem contentManagementSystem;

    SecurityChecker(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    private User getCurrentUser() {
        return this.contentManagementSystem.getCurrentUser();
    }

    void isSuperAdmin() throws NoPermissionException {
        if (!this.getCurrentUser().isSuperAdmin()) {
            throw new NoPermissionException("User is not superadmin.");
        }
    }

    void hasEditPermission(Document document) throws NoPermissionException {
        if (!this.getCurrentUser().canEdit(document)) {
            throw new NoPermissionException("The logged in user does not have permission to edit document " + document.getId());
        }
    }

    void hasAtLeastDocumentReadPermission(Document document) throws NoPermissionException {
        if (!this.getCurrentUser().getInternal().canAccess(document.getInternal())) {
            throw new NoPermissionException("The logged in user does not have permission to access document " + document.getId());
        }
    }

    void userHasPermissionToAddDocumentToAnyMenu(Document document) throws NoPermissionException {
        if (!this.getCurrentUser().getInternal().canAddDocumentToAnyMenu(document.getInternal())) {
            throw new NoPermissionException("The logged in user does not have permission to add this document to any menu " + document.getId());
        }
    }

    void canEditUser(User user) throws NoPermissionException {
        if (!(this.getCurrentUser().isUserAdmin() || this.getCurrentUser().isSuperAdmin() || user.equals(this.getCurrentUser()))) {
            throw new NoPermissionException("Must be the same user or superadmin.");
        }
    }

    void isNotDefaultUser() throws NoPermissionException {
        if (this.getCurrentUser().getInternal().isDefaultUser()) {
            throw new NoPermissionException("Can't be the default user.");
        }
    }
}

