/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.util.CountingIterator;
import imcode.server.Imcms;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import java.util.List;
import java.util.Set;

public class DocumentPermissionSet {
    public static final int FULL = DocumentPermissionSetTypeDomainObject.FULL.getId();
    public static final int RESTRICTED_1 = DocumentPermissionSetTypeDomainObject.RESTRICTED_1.getId();
    public static final int RESTRICTED_2 = DocumentPermissionSetTypeDomainObject.RESTRICTED_2.getId();
    public static final int READ = DocumentPermissionSetTypeDomainObject.READ.getId();
    public static final int NONE = DocumentPermissionSetTypeDomainObject.NONE.getId();
    private DocumentPermissionSetDomainObject internalDocPermSet;

    public DocumentPermissionSet(DocumentPermissionSetDomainObject internalDocPermSet) {
        this.internalDocPermSet = internalDocPermSet;
    }

    public String getType() {
        return this.internalDocPermSet.getTypeName();
    }

    public String toString() {
        return this.internalDocPermSet.toString();
    }

    public boolean getEditDocumentInformationPermission() {
        return this.internalDocPermSet.getEditDocumentInformation();
    }

    public boolean getEditRolePermissionsPermission() {
        return this.internalDocPermSet.getEditPermissions();
    }

    public boolean getEditTextsPermission() {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            return ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).getEditTexts();
        }
        return false;
    }

    public boolean getEditIncludesPermission() {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            return ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).getEditIncludes();
        }
        return false;
    }

    public boolean getEditPicturesPermission() {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            return ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).getEditImages();
        }
        return false;
    }

    public boolean getEditMenusPermission() {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            return ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).getEditMenus();
        }
        return false;
    }

    public String[] getEditableTemplateGroupNames() {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            Set allowedTemplateGroupIds = ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).getAllowedTemplateGroupIds();
            List allowedTemplateGroups = Imcms.getServices().getTemplateMapper().getTemplateGroups(allowedTemplateGroupIds);
            String[] templateGroupNames = new String[allowedTemplateGroupIds.size()];
            CountingIterator iterator = new CountingIterator(allowedTemplateGroups.iterator());
            while (iterator.hasNext()) {
                TemplateGroupDomainObject templateGroup = (TemplateGroupDomainObject)iterator.next();
                templateGroupNames[iterator.getCount() - 1] = templateGroup.getName();
            }
            return templateGroupNames;
        }
        return new String[0];
    }

    public void setEditDocumentInformationPermission(boolean b) {
        this.internalDocPermSet.setEditDocumentInformation(b);
    }

    public void setEditIncludesPermission(boolean b) {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).setEditIncludes(b);
        }
    }

    public void setEditPermissionsPermission(boolean b) {
        this.internalDocPermSet.setEditPermissions(b);
    }

    public void setEditPicturesPermission(boolean b) {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).setEditImages(b);
        }
    }

    public void setEditMenusPermission(boolean b) {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).setEditMenus(b);
        }
    }

    public void setEditTextsPermission(boolean b) {
        if (this.internalDocPermSet instanceof TextDocumentPermissionSetDomainObject) {
            ((TextDocumentPermissionSetDomainObject)this.internalDocPermSet).setEditTexts(b);
        }
    }

    public void setEditRolePermissionsPermission(boolean b) {
        this.internalDocPermSet.setEditPermissions(b);
    }
}

