/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DefaultContentManagementSystem;
import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.db.StringArrayResultSetHandler;
import com.imcode.imcms.db.StringFromRowFactory;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.CollectingHttpServletResponse;
import imcode.util.LocalizedMessage;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.w3c.dom.Document;

public class Utility {
    private static final Logger log = Logger.getLogger((String)Utility.class.getName());
    private static final String CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE = "com.imcode.imcms.ImcmsSystem";
    private static final LocalizedMessage ERROR__NO_PERMISSION = new LocalizedMessage("templates/login/no_permission.html/4");
    public static final ResultSetHandler SINGLE_STRING_HANDLER = new SingleObjectHandler((RowTransformer)new StringFromRowFactory());
    public static final ResultSetHandler STRING_ARRAY_HANDLER = new StringArrayResultSetHandler();
    public static final ResultSetHandler STRING_ARRAY_ARRAY_HANDLER = new StringArrayArrayResultSetHandler();

    private Utility() {
    }

    public static String ipLongToString(long ip) {
        return (ip >>> 24 & 0xFFL) + "." + (ip >>> 16 & 0xFFL) + "." + (ip >>> 8 & 0xFFL) + "." + (ip & 0xFFL);
    }

    public static long ipStringToLong(String ip) throws IllegalArgumentException {
        long ipInt = 0L;
        StringTokenizer ipTok = new StringTokenizer(ip, ".");
        if (4 != ipTok.countTokens()) {
            throw new IllegalArgumentException("Not a valid IPv4 address.");
        }
        int exp = 3;
        while (ipTok.hasMoreTokens()) {
            int ipNum = Integer.parseInt(ipTok.nextToken());
            ipInt = (long)((double)ipInt + (double)ipNum * Math.pow(256.0, exp));
            --exp;
        }
        return ipInt;
    }

    public static void setNoCache(HttpServletResponse res) {
        res.setHeader("Cache-Control", "no-cache; must-revalidate;");
        res.setHeader("Pragma", "no-cache;");
        res.setDateHeader("Expires", 0L);
    }

    public static UserDomainObject getLoggedOnUser(HttpServletRequest req) {
        return (UserDomainObject)req.getSession().getAttribute("logon.isDone");
    }

    public static int compareDatesWithNullFirst(Date date1, Date date2) {
        if (null == date1 && null == date2) {
            return 0;
        }
        if (null == date1) {
            return -1;
        }
        if (null == date2) {
            return 1;
        }
        return date1.compareTo(date2);
    }

    public static void setDefaultHtmlContentType(HttpServletResponse res) {
        res.setContentType("text/html; charset=windows-1252");
    }

    public static void redirectToStartDocument(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
    }

    public static boolean isValidEmail(String email) {
        return Pattern.compile("\\w+@\\w+").matcher(email).find();
    }

    public static void removeNullValuesFromMap(Map map) {
        Collection values = map.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            if (null != iterator.next()) continue;
            iterator.remove();
        }
    }

    public static String createQueryStringFromParameterMultiMap(MultiMap requestParameters) {
        Set requestParameterStrings = SetUtils.orderedSet(new HashSet());
        Iterator iterator = requestParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String parameterName = (String)entry.getKey();
            Collection parameterValues = (Collection)entry.getValue();
            Iterator valuesIterator = parameterValues.iterator();
            while (valuesIterator.hasNext()) {
                String parameterValue = (String)valuesIterator.next();
                requestParameterStrings.add(URLEncoder.encode(parameterName) + "=" + URLEncoder.encode(parameterValue));
            }
        }
        return StringUtils.join(requestParameterStrings.iterator(), (String)"&");
    }

    public static Collection collectImageDirectories() {
        ImcmsServices service = Imcms.getServices();
        File imagePath = service.getConfig().getImagePath();
        return FileUtility.collectRelativeSubdirectoriesStartingWith(imagePath);
    }

    public static Object firstElementOfSetByOrderOf(Set set, Comparator comparator) {
        TreeSet sortedSet = new TreeSet(comparator);
        sortedSet.addAll(set);
        return sortedSet.iterator().next();
    }

    public static boolean parameterIsSet(HttpServletRequest request, String parameter) {
        return null != request.getParameter(parameter);
    }

    public static int[] getParameterInts(HttpServletRequest request, String parameterName) {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (null == parameterValues) {
            return new int[0];
        }
        return Utility.convertStringArrayToIntArray(parameterValues);
    }

    public static int[] convertStringArrayToIntArray(String[] strings) {
        int[] parameterInts = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            parameterInts[i] = Integer.parseInt(strings[i]);
        }
        return parameterInts;
    }

    public static String getContents(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getRequestDispatcher(path);
        if (null == requestDispatcher) {
            throw new ServletException("No RequestDispatcher for path \"" + path + "\". Maybe the path doesn't exist?");
        }
        CollectingHttpServletResponse collectingHttpServletResponse = new CollectingHttpServletResponse(response);
        requestDispatcher.include((ServletRequest)request, (ServletResponse)collectingHttpServletResponse);
        return ((Object)((Object)collectingHttpServletResponse)).toString();
    }

    public static String formatDate(Date oneWeekAgo) {
        return new SimpleDateFormat("yyyy-MM-dd").format(oneWeekAgo);
    }

    public static String formatUser(UserDomainObject user) {
        return StringEscapeUtils.escapeHtml((String)(user.getLastName() + ", " + user.getFirstName() + " (" + user.getLoginName() + ")"));
    }

    public static String getAbsolutePathToDocument(HttpServletRequest request, DocumentDomainObject document) {
        if (null == document) {
            return null;
        }
        return request.getContextPath() + Utility.getContextRelativePathToDocument(document);
    }

    public static String getContextRelativePathToDocument(DocumentDomainObject document) {
        if (null == document) {
            return null;
        }
        return Utility.getContextRelativePathToDocumentWithId(document.getId());
    }

    public static String getContextRelativePathToDocumentWithId(int documentId) {
        String documentPathPrefix = Imcms.getServices().getConfig().getDocumentPathPrefix();
        if (StringUtils.isBlank((String)documentPathPrefix)) {
            documentPathPrefix = "/servlet/GetDoc?meta_id=";
        }
        return documentPathPrefix + documentId;
    }

    public static String formatHtmlDatetime(Date datetime) {
        if (null == datetime) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'&nbsp;'HH:mm");
        return dateFormat.format(datetime);
    }

    public static void forwardToLogin(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        StringBuffer loginTarget = request.getRequestURL();
        String queryString = request.getQueryString();
        if (null != queryString) {
            loginTarget.append("?").append(queryString);
        }
        response.setStatus(403);
        request.setAttribute("error", (Object)ERROR__NO_PERMISSION);
        request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + "/login/index.jsp?" + "next_url" + "=" + URLEncoder.encode(loginTarget.toString())).forward((ServletRequest)request, (ServletResponse)response);
    }

    public static String[] getParameterValues(HttpServletRequest request, String parameterName) {
        String[] parameterValues = request.getParameterValues(parameterName);
        if (null == parameterValues) {
            parameterValues = new String[]{};
        }
        return parameterValues;
    }

    public static Date truncateDateToMinutePrecision(Date fieldValue) {
        if (null == fieldValue) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(fieldValue);
        calendar.set(14, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static String getRequestURLWithoutPath(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        int requestUrlStartOfHost = requestUrl.indexOf("://") + 3;
        int requestUrlStartOfPath = requestUrl.indexOf(47, requestUrlStartOfHost);
        return StringUtils.left((String)requestUrl, (int)requestUrlStartOfPath);
    }

    public static boolean throwableContainsMessageContaining(Throwable t, String s) {
        for (Throwable throwable = t; null != throwable; throwable = throwable.getCause()) {
            String message = throwable.getMessage();
            log.debug((Object)(throwable + ": " + message));
            if (null == message || -1 == message.indexOf(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean classIsSignedByCertificatesInKeyStore(Class clazz, KeyStore keyStore) {
        Object[] signers = clazz.getSigners();
        if (null == signers) {
            return false;
        }
        for (int i = 0; i < signers.length; ++i) {
            Object signer = signers[i];
            if (!(signer instanceof Certificate)) {
                return false;
            }
            Certificate certificate = (Certificate)signer;
            try {
                if (null != keyStore.getCertificateAlias(certificate)) continue;
                return false;
            }
            catch (KeyStoreException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return true;
    }

    public static Map getMapViewOfObjectPairArray(Object[][] array) {
        return new ArrayMap((Object[])array, new ObjectPairToMapEntryTransformer());
    }

    public static String makeSqlStringFromDate(Date date) {
        if (null == date) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static Date parseDateFormat(DateFormat dateFormat, String dateString) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Object findMatch(Factory factory, Predicate predicate) {
        Object unique;
        while (!predicate.evaluate(unique = factory.create())) {
        }
        return unique;
    }

    public static String numberToAlphaNumerics(long identityHashCode) {
        return Long.toString(identityHashCode, 36);
    }

    public static Integer getInteger(Object object) {
        return null == object ? null : new Integer(((Number)object).intValue());
    }

    public static String escapeUrl(String imageUrl) {
        return URLEncoder.encode(imageUrl).replaceAll("%2F", "/").replaceAll("\\+", "%20");
    }

    public static void outputXmlDocument(HttpServletResponse response, Document xmlDocument) throws IOException {
        response.setContentType("text/xml; charset=UTF-8");
        Utility.writeXmlDocumentToStream(xmlDocument, (OutputStream)response.getOutputStream());
    }

    private static void writeXmlDocumentToStream(Document xmlDocument, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            javax.xml.transform.Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult outputTarget = new StreamResult(outputStream);
            DOMSource xmlSource = new DOMSource(xmlDocument);
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static void makeUserLoggedIn(HttpServletRequest req, UserDomainObject user) {
        req.getSession().setAttribute("logon.isDone", (Object)user);
        if (null != user) {
            user.setCurrentContextPath(req.getContextPath());
        }
    }

    public static void makeUserLoggedOut(HttpServletRequest req) {
        req.getSession().removeAttribute("logon.isDone");
    }

    public static ContentManagementSystem initRequestWithApi(ServletRequest request, UserDomainObject currentUser) {
        NDC.push((String)"initRequestWithApi");
        ImcmsServices service = Imcms.getServices();
        DefaultContentManagementSystem imcmsSystem = DefaultContentManagementSystem.create(service, currentUser);
        request.setAttribute(CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE, (Object)imcmsSystem);
        NDC.pop();
        return imcmsSystem;
    }

    public static ContentManagementSystem getContentManagementSystemFromRequest(ServletRequest request) {
        return (ContentManagementSystem)request.getAttribute(CONTENT_MANAGEMENT_SYSTEM_REQUEST_ATTRIBUTE);
    }

    private static class ArrayMap
    extends AbstractMap {
        private final Object[] array;
        private Transformer transformer;

        ArrayMap(Object[] array, Transformer transformer) {
            this.array = array;
            this.transformer = transformer;
        }

        public Set entrySet() {
            return new AbstractSet(){

                public int size() {
                    return ArrayMap.this.array.length;
                }

                public Iterator iterator() {
                    return new TransformIterator((Iterator)new ObjectArrayIterator(ArrayMap.this.array), ArrayMap.this.transformer);
                }
            };
        }
    }

    private static class ObjectPairToMapEntryTransformer
    implements Transformer {
        private ObjectPairToMapEntryTransformer() {
        }

        public Object transform(Object input) {
            final Object[] pair = (Object[])input;
            return new Map.Entry(){

                public Object getKey() {
                    return pair[0];
                }

                public Object getValue() {
                    return pair[1];
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

